<?php

namespace RtmMail\AjaxAction;

use RtmMail\Actions\Handlers\SendMultipleLogsAction;

class SendMultipleAjaxAction
{
    public function __construct()
    {
    }

    public function handleAction(): void
    {
        // Check if 'log_id' is posted and determine if it is a single ID or an array
        $logIds = $_POST['log_id'] ?? null;

        // Handle the case where 'log_id' could be either an array or a single scalar value
        if (is_array($logIds)) {
            // It's already an array, do nothing
        } elseif (isset($logIds)) {
            // Convert to array if it's a single log ID
            $logIds = [$logIds];
        } else {
            // No 'log_id' provided or it's empty
            wp_send_json_error(['message' => 'Log ID is required.']);
            return;
        }

        // Initialize the action handler
        $sendLogsAction = new SendMultipleLogsAction();

        // Process the logs
        $result = $sendLogsAction->handleAction($logIds);

        // Return the result as a JSON response
        wp_send_json($result);
    }
}
