<?php

namespace RtmMail\AjaxAction;

use RtmMail\Actions\Handlers\SaveSmtpSettingsAction;

class SaveSmtpSettingsAjaxAction
{
    public function handleAction(): void
    {
        $smtp_enabled = isset($_POST['smtp_enabled']) ? filter_var($_POST['smtp_enabled'], FILTER_VALIDATE_BOOLEAN) : false;
        $smtp_provider = sanitize_text_field($_POST['smtp_provider'] ?? '');

        $smtp_settings = $_POST['smtp_setting'] ?? [];
        foreach ($smtp_settings as $type => &$settingsGroup) {
            foreach ($settingsGroup as $key => &$value) {
                $value = sanitize_text_field($value);
            }
        }

        $data = [
            'smtp_enabled' => $smtp_enabled,
            'smtp_provider' => $smtp_provider,
            'smtp_setting' => $smtp_settings,
        ];

        $action = new SaveSmtpSettingsAction();
        $result = $action->handleAction($data);

        wp_send_json($result);
    }
}
