<?php

namespace RtmMail\AjaxAction;

use RtmMail\Actions\Handlers\SaveGeneralSettingsAction;

class SaveGeneralSettingsAjaxAction
{
    public function __construct()
    {
    }

    public function handleAction(): void
    {
        $settings = [
            'block_mails' => isset($_POST['block_mails']) ? filter_var($_POST['block_mails'], FILTER_VALIDATE_BOOLEAN) : false,
            'edit_mails' => isset($_POST['edit_mails']) ? filter_var($_POST['edit_mails'], FILTER_VALIDATE_BOOLEAN) : false,
            'sender_options' => [
                'title' => sanitize_text_field($_POST['sender_options']['title'] ?? ''),
                'address' => sanitize_text_field($_POST['sender_options']['address'] ?? '')
            ],
            'option_email' => $_POST['option_email'] ?? [],
            'outgoing_type' => $_POST['outgoing_type'] ?? [],
            'mail_capability' => sanitize_text_field($_POST['mail_capability'] ?? ''),
            'clear_deleted_events' => isset($_POST['clear_deleted_events']) ? filter_var($_POST['clear_deleted_events'], FILTER_VALIDATE_BOOLEAN) : false,
            'mail_cron_schedule' => sanitize_text_field($_POST['mail_cron_schedule'] ?? 'daily'),
            'mail_cron_enabled' => isset($_POST['mail_cron_enabled']) ? filter_var($_POST['mail_cron_enabled'], FILTER_VALIDATE_BOOLEAN) : false,

        ];
        $action = new SaveGeneralSettingsAction();
        $handle_action = $action->handleAction($settings);
        wp_send_json($handle_action);
    }
}
