<?php

namespace RtmMail\AjaxAction;

use RtmMail\Actions\Handlers\ResendMailAction;

class ResendMailAjaxAction
{
    public function __construct()
    {
    }

    public function handleAction(): void
    {
        // Check for required POST fields
        if (empty($_POST['log_id']) || empty($_POST['address'])) {
            wp_send_json_error(['message' => 'Missing required parameters.']);
            return;
        }

        // Extract and sanitize inputs
        $logId = sanitize_text_field($_POST['log_id']);
        $address = sanitize_email($_POST['address']);

        if (!filter_var($address, FILTER_VALIDATE_EMAIL)) {
            wp_send_json_error(['message' => 'Invalid email address.']);
            return;
        }

        // Create an instance of ResendMailAction and call handleAction with parameters
        $action = new ResendMailAction();
        $result = $action->handleAction($logId, $address);

        // Send JSON response back to the client
        wp_send_json($result);
    }
}
