<?php

namespace RtmMail\AjaxAction;

use RtmMail\Actions\Handlers\QueueLogAction;

class QueueLogsAjaxAction
{
    public function __construct()
    {
    }

    public function handleAction(): void
    {
        // Check for required variables
        if (empty($_POST['log_id']) || empty($_POST['queue_date'])) {
            wp_send_json_error(['message' => 'Missing required variables.']);
        }

        // Instantiate the action handler with context if needed
        $action = new QueueLogAction('queue_mail_context');

        // Convert log_id to an array if it's a single value
        $log_ids = is_array($_POST['log_id']) ? $_POST['log_id'] : [$_POST['log_id']];
        $queue_date = $_POST['queue_date'];
        $handle_action = $action->handleAction($log_ids, $queue_date);

        wp_send_json($handle_action);
    }
}
