<?php

namespace RtmMail\Actions\Handlers;

use RtmMail\Catcher;

class ResendMailAction extends AbstractActionHandler
{
    public function __construct()
    {
        parent::__construct('resend_mail', 'rtm_mail_resend_mail');
    }

    public function handleAction($logId = [], $address = ''): array
    {
        if (! $this->verifyNonce()) {
            return [ 'success' => false, 'message' => 'Nonce verification failed.' ];
        }

        // Attempt to resend the mail
        $mailSent = Catcher::sendMail($logId, $address);

        if ($mailSent === 'success') {
            return [
                'success'  => true,
                'message'  => 'Email successfully resent.',
            ];
        } else {
            return [
                'success'  => false,
                'message'  => 'Failed to resend email.',
            ];
        }
    }
}
