<?php

namespace RtmMail\Actions\Handlers;

use RtmMail\Helpers\LogHelper;
use RtmMail\Logger;
use RtmMail\Utils\LoggerUtils;

class DeleteLogAction extends AbstractActionHandler
{
    public function __construct($context = 'overview')
    {
        parent::__construct('delete_log', 'rtm_mail_delete_log', $context);
    }

    public function handleAction($logId = 0): array
    {
        $redirectUrl = '';
        if ($this->context === 'details') {
            $redirectUrl = get_admin_url() . 'admin.php?page=rtm-mail-overview';
        }
        // Verify nonce for security
        if (!$this->verifyNonce()) {
            return [ 'success' => false, 'message' => 'Nonce verification failed.' ];
        }

        // Check if log ID is provided
        if (empty($logId)) {
            return [ 'success' => false, 'message' => 'Log ID is required.' ];
        }

        // Perform the deletion
        LogHelper::delete([ 'id' => $logId ]);

        // Log the deletion
        $user_data = get_user_by('id', get_current_user_id());
        Logger::warning(
            "Deleted log #{$logId}",
            "Email Log (#{$logId}) has been deleted by {$user_data->display_name}",
            $this->context . ':handle_requests',
            'Log',
            [
               "mail_log" => $logId,
               "user"     => LoggerUtils::getUser(),
            ]
        );

        // Clear any scheduled hooks associated with this log
        wp_clear_scheduled_hook('rtm_mail_send_log', [ $logId ]);

        return [
            'success'  => true,
            'message'  => 'Log deleted successfully.',
            'redirect' => $redirectUrl
        ];
    }
}
