<?php

namespace RtmMail\Actions\Handlers;

// Abstract class to handle actions
abstract class AbstractActionHandler
{
    protected $action; // The action to be handled
    protected $nonce; // A one-time use security token
    protected $nonceAction; // The action associated with the nonce
    protected $context; // The context in which the action is being handled

    // Constructor to initialize the action handler
    public function __construct($action, $nonceAction, $context = 'default')
    {
        $this->action = $action;
        $this->nonceAction = $nonceAction;
        $this->nonce = $_REQUEST['_wpnonce'] ?? '';
        $this->context = $context;
    }

    // Verify the nonce to ensure the request is secure
    public function verifyNonce(): bool|int
    {
        return wp_verify_nonce($this->nonce, $this->nonceAction);
    }

    // Abstract method to handle the action, to be implemented by subclasses
    abstract public function handleAction();
}
