<?php

namespace RtmMail;

/**
 * AbstractPage - define inherited functions needed for every page
 */
abstract class AbstractPage
{
    /**
     * slug - the slug of the page
     * @var string
     */
    protected $slug;

    public function __construct()
    {
        add_action('admin_init', [$this, 'handle_requests']);
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     * @return mixed
     */
    abstract public function handle_requests();

    /**
     * display - Displays the page view for the user
     */
    public function display()
    {
        if ($this->page_check()) {
            require __DIR__ . '/Views/' . $this->slug . '.php';
        }
    }

    /**
     * page_check - check if the user is on the current page
     * @return bool
     */
    public function page_check()
    {
        $page = isset($_GET['page']) ? sanitize_key($_GET['page']) : '';
        return (substr($page, 0, 8) === 'rtm-mail') && (explode('-', $page)[2] == $this->slug);
    }
}