<?php
/**
 * Settings page
 */

// Get current settings options
use RtmMail\Cryptor;

global $handlers;

$encryption_key = get_option('rtm_mail_smtp_key', false);
if (empty($encryption_key)) {
    $encryption_key = wp_salt();
    update_option('rtm_mail_smtp_key', $encryption_key);
}

$settings = get_option('rtm_mail_smtp_settings');
$smtp_enabled = $settings['smtp_enabled'] ?? false;

$settings['smtp_settings']['other']['other_smtp_password'] = isset($settings['smtp_settings']['other']['other_smtp_password']) && !empty($settings['smtp_settings']['other']['other_smtp_password']) ? Cryptor::Decrypt($settings['smtp_settings']['other']['other_smtp_password'], $encryption_key) : '';
?>
<div class="wrap" id="rtm-mail">
    <?php \RtmMail\Core::render_page_header('mailsmtp'); ?>

    <div class="rtm-mail-page-content">
        <div class="rtm-page-info">
            <p class="heading rtm-heading"><?php echo __('Mail SMTP', 'rtm-mail'); ?></p>
            <p class="rtm-heading-description"><?php echo __('Here you can setup the SMTP settings of your WordPress site, you can choose to use the default PHP Mailer of a Custom SMTP Mailer.', 'rtm-mail'); ?></p>
            <h1 class="notice-header"><?php echo __('Mail SMTP', 'rtm-mail'); ?></h1>
        </div>
        <?php if (!$smtp_enabled || empty($host)) { ?>
            <div class="notice notice-warning">
                <div class="rtm-mail-notice-content">
                    <h2><?php echo __('Gmail SMTP', 'rtm-mail'); ?></h2>
                    <p><?php echo __('Google disabled the ability to enable less secure apps, however there is a work around if you still want to use the SMTP services for Gmail.'); ?></p>
                    <p>
                        <?php echo __('<strong>App passwords:</strong> You can still use the SMTP as normal, however you need to enable 2-Step Verification and set an App Password (security tab at my account). You need to use this password in stead of your normal Gmail account password.'); ?>
                    </p>
                    <p><?php echo __('Most SMTP servers require TLS or SSL authentication with the right port where you need to fill in your credentials. These credentials are encrypted and saved for this plugin.'); ?></p>
                </div>
            </div>
        <?php } ?>
        <hr>
        <div class="rtm-mail-page-content">
            <form id="rtm-mail-smtp-settings" action="" method="post">
                <input type="hidden" name="_wpnonce"
                       value="<?php echo esc_attr(wp_create_nonce('rtm_mail_save_smtp')); ?>"/>
                <div class="smtp-settings-container">
                    <div class="option-container">
                        <div class="settings-block">
                            <div class="settings-block-option">
                                <p class="option-label"><?php echo __('Enable Custom SMTP', 'rtm-mail'); ?></p>
                                <p class="option-description"><?php echo __('When enabled you can add a custom SMTP Mailer for this plugin, if this option is disabled it will use the default PHP mailer.', 'rtm-mail'); ?></p>
                            </div>
                            <div class="settings-block-input checkbox-input">
                                <label class="option-switch">
                                    <input type="checkbox" class="option-checkbox" id="enable__smtp"
                                           name="smtp_enabled" <?php echo checked(1, filter_var($smtp_enabled, FILTER_VALIDATE_BOOLEAN), false); ?> />
                                    <span class="option-slider">
                                        <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                        <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="option-container smtp__option" <?php echo ($smtp_enabled) ? 'style="opacity: 1.0; pointer-events:auto;"' : ''; ?>>
                        <div class="settings-block">
                            <div class="settings-block-option">
                                <p class="option-label"><?php echo __('SMTP Provider', 'rtm-mail'); ?></p>
                                <p class="option-description"><?php echo __('The SMTP provider you want to use.', 'rtm-mail'); ?></p>
                            </div>
                            <div class="settings-block-input smtp-provider-input">
                                <?php foreach ($handlers as $type => $handler) : ?>
                                    <input
                                        type="radio"
                                        class="smtp-provider-option"
                                        name="smtp_provider"
                                        <?php echo (isset($settings['smtp_provider']) && $settings['smtp_provider'] === $type) ? 'checked' : '' ; ?>
                                        value="<?php echo $type; ?>"
                                        id="<?php echo $type; ?>-provider"
                                    />
                                    <label for="<?php echo $type; ?>-provider" class="provider-check">
                                        <?php if (empty($handler['image'])) : ?>
                                            <h3 class="provider-logo"><?php echo $handler['title']; ?></h3>
                                        <?php else : ?>
                                            <img src="<?php echo RTM_MAIL_PLUGIN_PATH; ?>assets/images/<?php echo $handler['image']; ?>" alt="mail logo"
                                                 class="provider-logo"/>
                                        <?php endif; ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <?php foreach ($handlers as $type => $handler) : ?>
                            <div class="smtp__settings-container" id="<?php echo $type; ?>-smtp-settings" style="display: none;">
                               <?php foreach ($handler['fields'] as $field) : ?>
                                    <?php if ($field['type'] !== 'hidden') : ?>
                                       <div class="settings-block">
                                           <div class="settings-block-option">
                                               <p class="option-label"><?php echo $field['label']; ?></p>
                                               <p class="option-description"><?php echo $field['description'] ?></p>
                                           </div>
                                           <div class="settings-block-input checkbox-input">
                                               <?php if ($field['type'] === 'radio') : ?>
                                                    <?php foreach ($field['options'] as $option) : ?>
                                                       <div class="encryption-option">
                                                           <input
                                                               type="radio"
                                                               name="smtp_setting[<?php echo $type; ?>][<?php echo $field['key']; ?>]"
                                                                <?php
                                                                $currentVal = $settings['smtp_settings'][$type][$field['key']] ?? $field['default'];
                                                                if ($currentVal === $option['value']) {
                                                                    echo "checked";
                                                                }
                                                                ?>
                                                              value="<?php echo $option['value']; ?>"
                                                           />
                                                           <span class="radio-label"><?php echo $option['label']; ?></span>
                                                       </div>
                                                    <?php endforeach; ?>
                                               <?php elseif ($field['type'] === 'checkbox') : ?>
                                                   <label class="option-switch">
                                                       <input
                                                           type="checkbox" class="option-checkbox"
                                                           id="<?php echo $field['key']; ?>"
                                                          name="smtp_setting[<?php echo $type; ?>][<?php echo $field['key']; ?>]"
                                                           <?php echo checked(1, filter_var((isset($settings['smtp_settings'][$type][$field['key']]) && !empty($settings['smtp_settings'][$type][$field['key']])) ? $settings['smtp_settings'][$type][$field['key']] : $field['default'], FILTER_VALIDATE_BOOLEAN), false); ?>
                                                       />
                                                       <span class="option-slider">
                                                            <span class="option-slider-on"><?php echo __('ON', 'rtm-mail'); ?></span>
                                                            <span class="option-slider-off"><?php echo __('OFF', 'rtm-mail'); ?></span>
                                                        </span>
                                                   </label>
                                               <?php elseif ($field['type'] === 'submit') : ?>
                                                   <?php submit_button($field['label'], '', $field['key'], false, ['id' => $field['key'], 'style' => 'height: max-content;']); ?>
                                               <?php else : ?>
                                                   <input
                                                       type="<?php echo $field['type']; ?>"
                                                       name="smtp_setting[<?php echo $type; ?>][<?php echo $field['key']; ?>]"
                                                       id="<?php echo $field['key']; ?>"
                                                       class="form-input"
                                                       value="<?php echo (isset($settings['smtp_settings'][$type][$field['key']]) && !empty($settings['smtp_settings'][$type][$field['key']])) ? esc_html($settings['smtp_settings'][$type][$field['key']]) : esc_html($field['default']); ?>"
                                                       placeholder="<?php echo (isset($field['placeholder']) && !empty($field['placeholder'])) ? $field['placeholder'] : ''; ?>"
                                                       spellcheck="false"
                                                   />
                                               <?php endif; ?>
                                           </div>
                                       </div>
                                    <?php else : ?>
                                       <input
                                           type="<?php echo $field['type']; ?>"
                                           name="smtp_setting[<?php echo $type; ?>][<?php echo $field['key']; ?>]"
                                           id="<?php echo $field['key']; ?>"
                                           value="<?php echo (isset($settings['smtp_settings'][$type][$field['key']]) && !empty($settings['smtp_settings'][$type][$field['key']])) ? $settings['smtp_settings'][$type][$field['key']] : $field['default']; ?>"
                                       />
                                    <?php endif; ?>
                               <?php endforeach; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php submit_button(__('Save settings', 'rtm-mail'), '', 'save_settings', false, ['id' => 'save-settings']); ?>
                </div>
            </form>
        </div>
    </div>
</div>
