<?php

namespace RtmMail;

use RtmMail\Helpers\DashboardHelper;

/**
 * Dashboard - handles every user interaction for the dashboard page
 */
class Dashboard extends AbstractPage
{
    protected $slug = 'dashboard';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        if ($this->page_check()) {
            // Not implemented
        }
    }

    /**
     * display - Displays the page view for the user
     */
    public function display()
    {
        // Check if user is on the details page
        if ($this->page_check()) {
            global $dashboard;
            // set global $dashboard to the current loaded dashboard data
            $dashboard = DashboardHelper::get();
            // load in the details view for the user
            require __DIR__ . '/Views/' . $this->slug . '.php';
        }
    }
}