# WP Mail Logger Plugin

WP Mail Logger is a WordPress plugin used to catch every mail sent with the `wp_mail()` function and saves it to the database.

## Installation

### Composer

Use the package manager [composer](https://getcomposer.org/) to require rtm-mail plugin.

```bash
composer require rtmbusiness/rtm-mail
```

### Zip File

Download the ZIP file and upload it to WordPress Plugins

`Admin Dashboard -> Plugins -> New plugin -> Upload the ZIP file`

## Usage

Everytime the `wp_mail` function gets called inside your WordPress website it will trigger a filter where the recently sent email will get caught. This works inside for every outgoing mail from the website and every incoming mail from the website.

An example wp_mail function could look like this:
```php
wp_mail(get_option('admin_email'), 'This is a sample subject', '<h1>This is a test</h1><p>This is just a test mail to see if everything is working OK</p>', 'Content-Type:text/html', []);
```

## Debug
Every mail that gets caught, sent, failed or edited and every migration that is successful or fails will get logged in the Debug Events. However you will need to set the constant `WP_DEBUG_LOG` to `true`, otherwise the Debug Events will only log `ERROR` level events inside the rtm-mail plugin.

Inside the Debug Events you will also find the sent POST Request and Headers from when the mail was sent, the source of the sent email (user or IP-address) and a backtrace to function call (to see where the `wp_mail` function gets called from)

## License
[Proprietary](https://en.wikipedia.org/wiki/Software_license)