<?php
global $log;
$mail_log = $log[0] ?? null;

// Check if the current log is empty
if ($mail_log == null) {
    echo '<div class="notice notice-error"> ';
    echo '<p><strong>WP Mail Logger: </strong>';
    echo __('No log was found with this log_id', 'rtm-mail');
    echo '</p>';
    echo '</div>';
} else {
    $sender_options = $mail_log['headers']['from'] ?? null;
    $send_address = '';
    $send_title = '';
    if ($sender_options !== null) {
        $send_address = substr(explode('<', $sender_options)[1], 0, -1);
        $send_title = substr(explode('<', $sender_options)[0], 0, -1);
    }

    // Set defaults for sender option
    $settings = get_option('rtm_mail_settings');
    $sender_options = $settings['sender_options'] ?? null;
    $block_mails = isset($settings['block_mails']) && filter_var($settings['block_mails'], FILTER_VALIDATE_BOOLEAN);
    $edit_mails = isset($settings['edit_mails']) && filter_var($settings['edit_mails'], FILTER_VALIDATE_BOOLEAN);

    $sender_address_default = ($sender_options != null && !empty($sender_options['address'])) ? $sender_options['address'] : get_option('admin_email');
    $sender_title_default = ($sender_options != null && !empty($sender_options['title'])) ? $sender_options['title'] : get_bloginfo('name');
    ?>
    <div class="wrap" id="rtm-mail">
        <?php \RtmMail\Core::render_page_header('details'); ?>


        <div class="rtm-mail-page-content">
            <div class="rtm-page-info">
                <p class="heading rtm-heading"><?php echo __('Details', 'rtm-mail'); ?></p>
                <p class="rtm-heading-description"><?php echo __('On this page you will find the details about your selected email. You can also edit certain fields and send the email if it wasn\'t already sent. Always save the mail first before sending.', 'rtm-mail'); ?></p>
                <h1 class="notice-header"><?php echo __('Details', 'rtm-mail'); ?></h1>
            </div>
            <?php
            if ($mail_log['status'] === 'queued') {
                $queue_data = wp_get_scheduled_event('rtm_mail_send_log', [$mail_log['id']]);
                ?>
                <input type="hidden" name="queue_timestamp" id="queue__timestamp"
                       value="<?php echo $queue_data->timestamp; ?>"/>
                <div class="notice notice-warning">
                    <div class="rtm-mail-notice-content">
                        <h2><?php echo __('This log is queued!', 'rtm-mail'); ?></h2>
                        <p><?php echo __('This email log has been set in queue to be sent in <span class="queue__countdown"></span>. You can still edit the email however you like within the given queue time. You can also still send this email if you want, this will remove the email from the queue.'); ?></p>
                        <form method="post">
                            <input type="hidden" name="_wpnonce_remove_queue"
                                   value="<?php echo esc_attr(wp_create_nonce('rtm_mail_remove_queue')); ?>"/>
                            <input type="hidden" name="action" value="remove_queue"/>
                            <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                            <input type="hidden" name="queue_timestamp" value="<?php echo $queue_data->timestamp; ?>"/>
                            <button type="submit" name="remove_log_queue"
                                    class="button button-delete"><?php echo __('Remove mail from queue', 'rtm-mail'); ?></button>
                        </form>
                    </div>
                </div>
                <?php
            }
            ?>
            <hr>
            <div class="rtm-mail-page-details">
                <div class="details-edit-box">
                    <form method="post">
                        <input type="hidden" name="action" value="edit"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_edit_log')); ?>"/>
                        <div class="details-heading" style="border-top: none">
                            <span class="heading-title"><?php echo __('Sender options', 'rtm-mail'); ?></span>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <div class="sender-preset-box" style="display: flex; margin-bottom: 15px;">
                                    <div class="sender-preset-list">
                                        <p class="edit-input-label"><?php echo __('Sender preset', 'rtm-mail'); ?></p>
                                        <select class="sender-preset"
                                                name="sender_preset" <?php echo ($mail_log['status'] == 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?>>
                                            <option value=""><?php _e('Select a preset', 'rtm-mail'); ?></option>
                                            <option value="<?php echo $sender_title_default . ';' . $sender_address_default; ?>"><?php _e('Default', 'rtm-mail'); ?></option>
                                            <option value="admin_user">Admin User</option>
                                            <option value="custom">Custom</option>
                                        </select>
                                    </div>
                                    <div class="sender-preset-list" id="admin-preset-list" style="display: none;">
                                        <p class="edit-input-label"><?php echo __('Admin list', 'rtm-mail'); ?></p>
                                        <select class="admin-sender-preset"
                                                name="admin_sender" <?php echo ($mail_log['status'] == 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?>>
                                            <option value=""><?php _e('Select a user', 'rtm-mail'); ?></option>
                                            <?php
                                            $users = get_users(['orderby' => 'user_nicename', 'order' => 'ASC', 'role__in' => 'administrator']);
                                            foreach ($users as $user) {
                                                ?>
                                                <option value="<?php echo $user->display_name . ';' . $user->user_email; ?>"><?php echo $user->display_name; ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="sender-preset-input">
                                    <div class="sender-input-box">
                                        <p class="edit-input-label"><?php echo __('Mail title', 'rtm-mail'); ?></p>
                                        <input type="text" name="sender_options[title]" id="sender_preset_title"
                                               value="<?php echo $send_title; ?>"
                                               class="edit-input-text edit-preset-text" <?php echo ($mail_log['status'] == 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?> />
                                    </div>
                                    <div class="sender-input-box">
                                        <p class="edit-input-label"><?php echo __('Sender address', 'rtm-mail'); ?></p>
                                        <input type="text" name="sender_options[address]" id="sender_preset_address"
                                               value="<?php echo $send_address; ?>"
                                               class="edit-input-text edit-preset-text" <?php echo ($mail_log['status'] == 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?> />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="details-heading">
                            <span class="heading-title"><?php echo __('Mail Details', 'rtm-mail'); ?></span>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('Receiver', 'rtm-mail'); ?></p>
                                <input type="text" name="receiver" id="edit_receiver"
                                       value="<?php echo !empty($mail_log['receiver']) ? implode(';', $mail_log['receiver']) : ''; ?>"
                                       class="edit-input-text" <?php echo ($mail_log['status'] == 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?> />
                            </div>
                            <div class="edit-buttons">
                                <?php
                                if ($mail_log['status'] !== 'sent' || $edit_mails) {
                                    ?>
                                    <button type="button" name="add-receiver" id="add_receiver"
                                            class="button button-invert">+
                                    </button>
                                    <button type="button" name="remove-receiver" id="remove_receiver"
                                            class="button button-invert-remove">-
                                    </button>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('CC', 'rtm-mail'); ?></p>
                                <input type="text" name="cc" id="edit_cc"
                                       value="<?php echo !empty($mail_log['cc']) ? implode(';', $mail_log['cc']) : ''; ?>"
                                       class="edit-input-text" <?php echo ($mail_log['status'] === 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?> />
                            </div>
                            <div class="edit-buttons">
                                <?php
                                if ($mail_log['status'] !== 'sent' || $edit_mails) {
                                    ?>
                                    <button type="button" name="add-cc" id="add_cc" class="button button-invert">+
                                    </button>
                                    <button type="button" name="remove-cc" id="remove_cc"
                                            class="button button-invert-remove">
                                        -
                                    </button>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('BCC', 'rtm-mail'); ?></p>
                                <input type="text" name="bcc" id="edit_bcc"
                                       value="<?php echo !empty($mail_log['bcc']) ? implode(';', $mail_log['bcc']) : ''; ?>"
                                       class="edit-input-text" <?php echo ($mail_log['status'] === 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?> />
                            </div>
                            <div class="edit-buttons">
                                <?php
                                if ($mail_log['status'] !== 'sent' || $edit_mails) {
                                    ?>
                                    <button type="button" name="add-bcc" id="add_bcc" class="button button-invert">+
                                    </button>
                                    <button type="button" name="remove-bcc" id="remove_bcc"
                                            class="button button-invert-remove">
                                        -
                                    </button>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input">
                                <p class="edit-input-label"><?php echo __('Subject', 'rtm-mail'); ?></p>
                                <input type="text" name="subject" id="edit_subject"
                                       value="<?php echo $mail_log['subject']; ?>"
                                       class="edit-input-text" <?php echo ($mail_log['status'] === 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?> />
                            </div>
                        </div>
                        <div class="details-edit-input">
                            <div class="edit-input" style="width: 100%">
                                <p class="edit-input-label"><?php echo __('Body (content)', 'rtm-mail'); ?></p>
                                <textarea name="body" id="edit_body"
                                          class="edit-input-text edit-input-body" <?php echo ($mail_log['status'] === 'sent' && !$edit_mails) ? 'disabled="true"' : '' ?>><?php echo $mail_log['body']; ?></textarea>
                            </div>
                        </div>
                        <?php if ($mail_log['status'] !== 'sent' || $edit_mails) { ?>
                            <div class="details-edit-input">
                                <?php submit_button(__('Save mail', 'rtm-mail'), '', 'save_mail_log', false, ['id' => 'save-mail-log']); ?>
                            </div>
                        <?php } ?>
                    </form>
                </div>

                <div class="details-detail-box">
                    <div class="details-heading">
                        <span class="heading-title"><?php echo __('Details', 'rtm-mail'); ?></span>
                    </div>
                    <div class="detail-status">
                        <div class="detail-status-box">
                            <p class="edit-input-label"><?php echo __('Status', 'rtm-mail'); ?></p>
                            <?php
                            $label = __('Caught', 'rtm-mail');
                            switch ($mail_log['status']) {
                                case 'caught':
                                    $label = __('Caught', 'rtm-mail');
                                    break;
                                case'sent':
                                    $label = __('Sent', 'rtm-mail');
                                    break;
                                case 'failed':
                                    $label = __('Failed', 'rtm-mail');
                                    break;
                                case 'queued':
                                    $label = __('Queued', 'rtm-mail');
                                    break;
                            }
                            echo '<p><span class="badge badge-' . $mail_log['status'] . '">' . $label . '</span></p>';
                            ?>
                        </div>
                        <div class="detail-status-box">
                            <p class="edit-input-label"><?php echo __('Sender', 'rtm-mail'); ?></p>
                            <p><?php echo $mail_log['sender']; ?></p>
                        </div>
                        <div class="detail-status-box">
                        </div>
                    </div>
                    <div class="detail-dates">
                        <div class="detail-date-box">
                            <p class="edit-input-label"><?php echo __('Creation date', 'rtm-mail'); ?></p>
                            <p><?php echo date_format(date_create($mail_log['created']), 'd-m-Y H:i'); ?></p>
                        </div>
                        <div class="detail-date-box">
                            <p class="edit-input-label"><?php echo __('Updated on', 'rtm-mail'); ?></p>
                            <p><?php echo !empty($mail_log['updated']) ? date_format(date_create($mail_log['updated']), 'd-m-Y H:i') : __('Not updated yet...', 'rtm-mail'); ?></p>
                        </div>
                        <div class="detail-date-box">
                            <p class="edit-input-label"><?php echo __('Date sent', 'rtm-mail'); ?></p>
                            <p><?php echo !empty($mail_log['sent']) ? date_format(date_create($mail_log['sent']), 'd-m-Y H:i') : __('Not sent yet...', 'rtm-mail'); ?></p>

                        </div>
                    </div>
                    <div class="detail-attachments">
                        <p class="edit-input-label"><?php echo __('Attachments', 'rtm-mail'); ?></p>
                        <div class="attachments-box">
                            <?php
                            if (isset($mail_log['attachments']) && !empty($mail_log['attachments'])) {
                                foreach ($mail_log['attachments'] as $attachment) {
                                    $upload = wp_upload_dir();
                                    $file_path = str_replace($upload['basedir'], '', $attachment);
                                    $file_name = substr($attachment, strrpos($attachment, '/'));
                                    ?>
                                    <a style="text-decoration: none!important;"
                                       href="<?php echo $upload['baseurl'] . $file_path; ?>" target="_blank">
                                        <div class="attachment-item" data-file="<?php echo $file_name; ?>">
                                            <div class="attachment-item-detail">
                                                <p class="edit-input-label"><?php echo __('File name', 'rtm-mail'); ?></p>
                                                <p class="attachment-name"><?php echo $file_name; ?></p>
                                            </div>
                                            <div class="attachment-item-detail">
                                                <p class="edit-input-label"><?php echo __('File type', 'rtm-mail'); ?></p>
                                                <p class="extension-name"><?php echo pathinfo($attachment, PATHINFO_EXTENSION); ?></p>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                }
                            } else {
                                echo __('No attachments to this mail...', 'rtm-mail');
                            }
                            ?>
                        </div>
                    </div>
                    <div class="details-heading" style="margin-bottom: 10px;">
                        <span class="heading-title"><?php echo __('Actions', 'rtm-mail'); ?></span>
                    </div>
                    <div class="detail-buttons">
                        <input type="button" name="preview-mail" id="preview_mail" class="button"
                               value="<?php echo __('Preview', 'rtm-mail'); ?>"/>
                        <input type="button" name="delete_log" id="delete_log" class="button button-delete"
                               value="<?php echo __('Delete', 'rtm-mail'); ?>"/>
                        <input type="button" name="send_mail" id="send_mail" class="button button-success"
                               value="<?php echo __('Send Mail', 'rtm-mail'); ?>"/>
                    </div>
                    <?php
                    if ($mail_log['status'] !== 'queued' && $mail_log['status'] !== 'sent' && $edit_mails) {
                        ?>
                        <div class="detail-queue">
                            <form method="post">
                                <input type="text" id="rtm-queue-date" name="queue_date"
                                       placeholder="<?php echo __('Select a date', 'rtm-mail'); ?>"/>
                                <input type="hidden" name="action" value="queue_log"/>
                                <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                                <input type="hidden" name="_wpnonce"
                                       value="<?php echo esc_attr(wp_create_nonce('rtm_mail_queue_mails')); ?>"/>
                                <button type="button" name="queue-log" id="queue-mail-log" class="button"
                                        disabled><?php echo __('Queue mail for date', 'rtm-mail'); ?></button>
                            </form>
                        </div>
                        <?php
                    }
                    ?>
                </div>

                <div class="details-detail-box receiver-status-box">
                    <div class="details-heading receiver-status-heading">
                        <span class="heading-title"><?php echo __('Receivers status', 'rtm-mail'); ?></span>
                        <div class="receiver-actions">
                            <button type="button" class="receiver-status-button-toggle" style="margin-right: 10px;" data-type="sent"><i class="fas fa-paper-plane"></i></button>
                            <button type="button" class="receiver-status-button-toggle" data-type="opened"><i class="fas fa-envelope-open"></i></button>
                        </div>
                    </div>
                    <div class="details-receiver-status" style="padding: 0">
                        <?php if (isset($mail_log['receiver_status'])) { ?>
                        <table class="receiver-status-table" cellspacing="0">
                            <tbody>
                                <tr>
                                    <th class="receiver-address-head"><i class="fas fa-at"></i> <span><?php echo __('Address', 'rtm-mail'); ?></span></th>
                                    <th class="receiver-sent-head"><i class="fas fa-paper-plane"></i> <span><?php echo __('Sent', 'rtm-mail'); ?></span></th>
                                    <th class="receiver-opened-head"><i class="fas fa-envelope-open"></i> <span><?php echo __('Opened', 'rtm-mail'); ?></span></th>
                                    <th class="receiver-resend-head"><i class="fas fa-reply"></i> <span><?php echo __('Resend', 'rtm-mail'); ?></span></th>
                                </tr>
                                <?php foreach ($mail_log['receiver_status'] as $address => $address_status) { ?>
                                <tr>
                                    <td class="address-cell"><?php echo $address; ?></td>
                                    <td class="sent-cell"><?php echo ($address_status['sent'] ?? false) ? '<i class="fas fa-check-circle status-on"></i>' : '<i class="fas fa-times-circle status-off"></i>' ?></td>
                                    <td class="opened-cell"><?php echo ($address_status['opened'] ?? false) ? '<i class="fas fa-check-circle status-on"></i>' : '<i class="fas fa-times-circle status-off"></i>' ?></td>
                                    <td class="resend-cell-default"><input type="button" name="resend_mail" id="resend_mail" class="button button-success" data-address="<?php echo $address; ?>" value="<?php echo __('Resend', 'rtm-mail'); ?>" /></td>
                                    <td class="resend-cell-mobile"><a href="#" id="resend_mail" class="resend-email-link" data-address="<?php echo $address; ?>"><i class="fas fa-share-square"></i></a></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                        <?php } else { ?>
                                <p style="padding: 5px 15px;"><?php echo __('No receiver status available for this log', 'rtm-mail'); ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal resend-modal" id="modal_resend_mail">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Resend mail', 'rtm-mail'); ?></h3>
                    <i class="fas fa-times modal-close" data-id="resend_mail"></i>
                </div>
                <hr>
                <div class="modal-content">
                    <p>
                        <strong class="action_message"><?php echo __('Are you sure you want to resend the mail to <span class="modal__address"></span>?', 'rtm-mail'); ?></strong>
                    </p>

                    <form method="post">
                        <input type="hidden" name="action" value="resend_mail"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <input type="hidden" name="address" id="resend__address" value=""/>
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_resend_mail')); ?>"/>
                        <button type="submit" name="resend-mail" class="button button-success"
                                id="confirm_action"><?php echo __('Resend', 'rtm-mail'); ?></button>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal add-modal" id="modal_log_queue">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Add to queue', 'rtm-mail'); ?></h3>
                    <i class="fas fa-times modal-close" data-id="log_queue"></i>
                </div>
                <hr>
                <div class="modal-content">
                    <p>
                        <strong class="action_message"><?php echo __('Are you sure you want to queue the selected mail log for <span class="modal__datetime"></span>?', 'rtm-mail'); ?></strong>
                    </p>
                    <form method="post">
                        <input type="hidden" id="hidden__queue__date" name="queue_date"
                               value=""/>
                        <input type="hidden" name="action" value="queue_log"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_queue_mails')); ?>"/>
                        <button type="submit" name="queue-mail-log" class="button"
                                id="confirm_action"><?php echo __('Queue mail for date', 'rtm-mail'); ?></button>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal preview-modal" id="modal_preview">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Preview', 'rtm-mail'); ?></h3>
                    <i class="fas fa-times modal-close" data-id="preview"></i>
                </div>
                <hr>
                <div class="modal-content">
                    <iframe src="?page=rtm-mail-details&mail_preview=true&log_id=<?php echo $mail_log['id']; ?>"
                            class="mail-preview"></iframe>
                </div>
            </div>
        </div>
        <div class="modal add-modal" id="modal_add_mail">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Add address', 'rtm-mail'); ?></h3>
                    <i class="fas fa-times modal-close" data-id="add_mail"></i>
                </div>
                <hr>
                <div class="modal-content">
                    <input type="hidden" name="type" id="add_type" value="receiver"/>
                    <p class="edit-input-label"><?php echo __('Address', 'rtm-mail'); ?>:</p>
                    <input type="text" name="mail_address" id="add_mail_address" class="edit-input-text"
                           placeholder="Type an address..."/>
                    <button type="button" class="button" id="save_added_address"
                            style="margin-top: 10px;"><?php echo __('Save', 'rtm-mail'); ?></button>
                </div>
            </div>
        </div>
        <div class="modal remove-modal" id="modal_remove_mail">
            <div class="modal-container">
                <div class="modal-header">
                    <h3><?php echo __('Remove address', 'rtm-mail'); ?></h3>
                    <i class="fas fa-times modal-close" data-id="remove_mail"></i>
                </div>
                <hr>
                <div class="modal-content">
                    <input type="hidden" name="type" id="remove_type" value="receiver"/>
                    <div id="remove_mail_list">
                    </div>
                    <button type="button" class="button"
                            id="save_removed_address"><?php echo __('Save', 'rtm-mail'); ?></button>
                </div>
            </div>
        </div>
        <div class="modal delete-log-modal" id="modal_delete_log">
            <div class="modal-container">
                <div class="modal-header" style="display: block!important;">
                    <i class="fas fa-times modal-close" data-id="delete_log"></i>
                </div>
                <div class="modal-content">
                    <form method="post">
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_delete_log')); ?>"/>
                        <input type="hidden" name="action" value="delete_log"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <p>
                            <strong><?php echo __('Are you sure you want to delete this mail log?', 'rtm-mail'); ?></strong>
                        </p>
                        <button type="submit" name="delete_log" class="button button-delete"
                                id="confirm_delete_log"><?php echo __('Delete', 'rtm-mail'); ?></button>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal delete-log-modal" id="modal_send_log">
            <div class="modal-container">
                <div class="modal-header" style="display: block!important;">
                    <i class="fas fa-times modal-close" data-id="send_log"></i>
                </div>
                <div class="modal-content">
                    <form method="post">
                        <input type="hidden" name="_wpnonce"
                               value="<?php echo esc_attr(wp_create_nonce('rtm_mail_send_log')); ?>"/>
                        <input type="hidden" name="action" value="send_log"/>
                        <input type="hidden" name="log_id" value="<?php echo $mail_log['id']; ?>"/>
                        <p><strong><?php echo __('Are you sure you want to send this email?', 'rtm-mail'); ?></strong>
                        </p>
                        <button type="submit" name="send_log" class="button button-success"
                                id="confirm_send_log"><?php echo __('Send', 'rtm-mail'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php
}
