<?php
global $events;
global $log;
$mail_log = $log[0] ?? null;
if (isset($events[0])) {
    ?>
    <div class="wrap" id="rtm-mail">
        <?php \RtmMail\Core::render_page_header('event_details'); ?>

        <div class="rtm-mail-page-content">
            <div class="rtm-page-info">
                <p class="heading rtm-heading"><?php echo __('Details', 'rtm-mail'); ?></p>
                <p class="rtm-heading-description"><?php echo __('On this page you will find the details about your selected email. You can also edit certain fields and send the email if it wasn\'t already sent. Always save the mail first before sending.', 'rtm-mail'); ?></p>
                <h1 class="notice-header"><?php echo __('Details', 'rtm-mail'); ?></h1>
            </div>
            <hr>
            <div class="rtm-mail-page-details">
                <div class="details-event-box">
                    <h2 class="event-title"><?php echo __('All events', 'rtm-mail'); ?></h2>
                    <div class="event-detail-container">
                        <?php foreach ($events as $event) { ?>
                            <div class="event-detail-item">
                                <?php
                                $level = '<span class="badge">' . $event->getSeverity() . '</span>';
                                switch ($event->getSeverity()) {
                                    case 'warning':
                                        $level = '<span class="badge badge-caught">' . $event->getSeverity() . '</span>';
                                        break;
                                    case 'error':
                                        $level = '<span class="badge badge-failed">' . $event->getSeverity() . '</span>';
                                        break;
                                }
                                ?>
                                <div class="event-detail-block"><?php echo $level . ' ' . $event->getTitle(); ?> <span
                                            class="event-detail-icon"><i
                                                class="fas fa-caret-left caret__icon"></i></span></div>
                                <div class="event-details-expand">
                                    <div class="event-details-error">
                                        <p class="edit-input-label"><?php echo __('Event message', 'rtm-mail'); ?></p>
                                        <p><?php echo $event->getMessage(); ?></p>
                                    </div>
                                    <div class="detail-dates">
                                        <div class="detail-date-box">
                                            <?php if (isset($event->getData()['mail_log'])) : ?>
                                            <p class="edit-input-label"><?php echo __('Log ID', 'rtm-mail'); ?></p>
                                            <?php
                                            if ($mail_log != null) {
                                                echo '<p><a href="' . get_admin_url() . 'admin.php?page=rtm-mail-details&log_id=' . $event->getData()['mail_log'] . '">' . $event->getData()['mail_log'] . '</a></p>';
                                            } else {
                                                echo '<p>' . $event->getData()['mail_log'] . '</p>';
                                            }
                                            ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="detail-date-box">
                                            <p class="edit-input-label"><?php echo __('User', 'rtm-mail'); ?></p>
                                            <?php
                                            if (isset($event->getData()['user'])) {
                                                // Get user_id from string
                                                $user_id = (int)filter_var($event->getData()['user'], FILTER_SANITIZE_NUMBER_INT);
                                                $user_data = get_user_by('id', $user_id);
                                                if (!empty($user_data)) {
                                                    ?>
                                                    <p>
                                                        <a href="<?php echo get_admin_url(); ?>user-edit.php?user_id=<?php echo $user_id; ?>"><?php echo $event->getData()['user']; ?></a>
                                                    </p>
                                                    <?php
                                                } else {
                                                    ?>
                                                    <p><?php echo $event->getData()['user'] ?></p>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <p><?php echo __('No source was given') ?></p>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                        <div class="detail-date-box">
                                            <p class="edit-input-label"><?php echo __('Date', 'rtm-mail'); ?></p>
                                            <p><?php echo $event->getTimestamp()->format('d-m-Y h:i:s') ?></p>
                                        </div>
                                    </div>
                                    <?php if (isset($event->getData()['request'])) { ?>
                                        <div class="event-details-request">
                                            <p class="edit-input-label"><?php echo __('Request Parameters', 'rtm-mail'); ?></p>
                                            <div class="event-request-parameters">
                                                <?php echo $this->build_dump($event->getData()['request']); ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <?php if (isset($event->getData()['changed_settings'])) : ?>
                                        <div class="event-details-request">
                                            <p class="edit-input-label"><?php echo __('Changed settings', 'rtm-mail'); ?></p>
                                            <div class="event-request-parameters">
                                                <?php echo $this->build_dump($event->getData()['changed_settings']); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="details-backtrace-box">
                    <?php if ($mail_log !== null && isset($mail_log['backtrace'])) { ?>
                        <h2 class="event-title"><?php echo __('Details', 'rtm-mail'); ?></h2>
                        <div class="detail-backtrace">
                            <p class="edit-input-label"><?php echo __('Caught Mail Backtrace', 'rtm-mail'); ?></p>
                            <div class="backtrace-container">
                                <?php foreach ($mail_log['backtrace'] as $trace) { ?>
                                    <?php if ($trace['call'] === 'wp_mail') { ?>
                                        <div class="backtrace-item" style="background: #d8fcd4;">
                                            <p><span class="badge badge-trace"><?php echo $trace['call'] ?></span>
                                                called on line <strong><?php echo $trace['line'] ?></strong> in
                                                <code><?php echo $trace['file'] ?></code></p>
                                        </div>
                                    <?php } else { ?>
                                        <div class="backtrace-item">
                                            <p><span class="badge badge-trace"><?php echo $trace['call'] ?></span>
                                                called on line <strong><?php echo $trace['line'] ?></strong> in
                                                <code><?php echo $trace['file'] ?></code></p>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php
} else {
    echo '<div class="notice notice-error"> ';
    echo '<p><strong>WP Mail Logger: </strong>';
    echo __('No events were found with this log_id', 'rtm-mail');
    echo '</p>';
    echo '</div>';
}
