<?php
global $events;
global $log;
$mail_log = $log[0] ?? null;
if (isset($events[0])) {
    ?>
    <div class="wrap" id="rtm-mail">
        <?php \RtmMail\Core::render_page_header('event_details'); ?>

        <div class="rtm-mail-page-content">
            <div class="rtm-page-info">
                <p class="heading rtm-heading"><?php echo __('Details', 'rtm-mail'); ?></p>
                <p class="rtm-heading-description"><?php echo __('On this page you will find the details about your selected email. You can also edit certain fields and send the email if it wasn\'t already sent. Always save the mail first before sending.', 'rtm-mail'); ?></p>
                <h1 class="notice-header"><?php echo __('Details', 'rtm-mail'); ?></h1>
            </div>
            <hr>
            <div class="rtm-mail-page-details">
                <div class="details-event-box">
                    <h2 class="event-title"><?php echo __('All events', 'rtm-mail'); ?></h2>
                    <div class="event-detail-container">
                        <?php foreach ($events as $event) { ?>
                            <div class="event-detail-item">
                                <?php
                                $level = '<span class="badge">' . $event['level'] . '</span>';
                                switch ($event['level']) {
                                    case 'DEBUG':
                                        $level = '<span class="badge badge-caught">' . $event['level'] . '</span>';
                                        break;
                                    case 'ERROR':
                                        $level = '<span class="badge badge-failed">' . $event['level'] . '</span>';
                                        break;
                                }
                                ?>
                                <div class="event-detail-block"><?php echo $level . ' ' . $event['message']; ?> <span
                                            class="event-detail-icon"><i
                                                class="fas fa-caret-left caret__icon"></i></span></div>
                                <div class="event-details-expand">
                                    <?php if (isset($event['context']['error'])) { ?>
                                        <div class="event-details-error">
                                            <p class="edit-input-label"><?php echo __('Error message', 'rtm-mail'); ?></p>
                                            <p><code><?php echo $event['context']['error']; ?></code></p>
                                        </div>
                                    <?php } ?>
                                    <div class="detail-dates">
                                        <div class="detail-date-box">
                                            <p class="edit-input-label"><?php echo __('Log ID', 'rtm-mail'); ?></p>
                                            <?php
                                            if ($mail_log != null) {
                                                echo '<p><a href="' . get_admin_url() . 'admin.php?page=rtm-mail-details&log_id=' . $event['context']['log_id'] . '">' . $event['context']['log_id'] . '</a></p>';
                                            } else {
                                                echo '<p>' . $event['context']['log_id'] . '</p>';
                                            }
                                            ?>
                                        </div>
                                        <div class="detail-date-box">
                                            <p class="edit-input-label"><?php echo __('Source', 'rtm-mail'); ?></p>
                                            <?php
                                            if (isset($event['context']['source'])) {
                                                // Get user_id from string
                                                $user_id = (int)filter_var($event['context']['source'], FILTER_SANITIZE_NUMBER_INT);
                                                $user_data = get_user_by('id', $user_id);
                                                if (!empty($user_data)) {
                                                    ?>
                                                    <p>
                                                        <a href="<?php echo get_admin_url(); ?>user-edit.php?user_id=<?php echo $user_id; ?>"><?php echo $event['context']['source']; ?></a>
                                                    </p>
                                                    <?php
                                                } else {
                                                    ?>
                                                    <p><?php echo $event['context']['source'] ?></p>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <p><?php echo __('No source was given') ?></p>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                        <div class="detail-date-box">
                                            <p class="edit-input-label"><?php echo __('Date', 'rtm-mail'); ?></p>
                                            <p><?php echo $event['date']->format('d-m-Y h:i:s') ?></p>
                                        </div>
                                    </div>
                                    <div class="event-details-wp">
                                        <p class="edit-input-label"><?php echo __('Wordpress Data', 'rtm-mail'); ?></p>
                                        <?php
                                        foreach ($event['extra']['wp'] as $data_type => $data_value) {
                                            if ($data_type !== 'user_id') {
                                                $data_value = $data_value ? 'true' : 'false';
                                                echo '<span class="button badge-wp-data" style="margin-right: 5px; font-size:12px;">' . $data_type . ': <strong>' . $data_value . '</strong></span>';
                                            } else {
                                                echo '<span class="button badge-wp-data" style="margin-right: 5px; font-size:12px;">' . $data_type . ': <strong>' . $data_value . '</strong></span>';
                                            }
                                        }
                                        ?>
                                    </div>
                                    <?php if (isset($event['context']['request'])) { ?>
                                        <div class="event-details-request">
                                            <p class="edit-input-label"><?php echo __('Request Parameters', 'rtm-mail'); ?></p>
                                            <div class="event-request-parameters">
                                                <?php echo $this->build_dump($event['context']['request']); ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="details-backtrace-box">
                    <?php if ($mail_log !== null && isset($mail_log['backtrace'])) { ?>
                        <h2 class="event-title"><?php echo __('Details', 'rtm-mail'); ?></h2>
                        <div class="detail-backtrace">
                            <p class="edit-input-label"><?php echo __('Caught Mail Backtrace', 'rtm-mail'); ?></p>
                            <div class="backtrace-container">
                                <?php foreach ($mail_log['backtrace'] as $trace) { ?>
                                    <?php if ($trace['call'] === 'wp_mail') { ?>
                                        <div class="backtrace-item" style="background: #d8fcd4;">
                                            <p><span class="badge badge-trace"><?php echo $trace['call'] ?></span>
                                                called on line <strong><?php echo $trace['line'] ?></strong> in
                                                <code><?php echo $trace['file'] ?></code></p>
                                        </div>
                                    <?php } else { ?>
                                        <div class="backtrace-item">
                                            <p><span class="badge badge-trace"><?php echo $trace['call'] ?></span>
                                                called on line <strong><?php echo $trace['line'] ?></strong> in
                                                <code><?php echo $trace['file'] ?></code></p>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php
} else {
    echo '<div class="notice notice-error"> ';
    echo '<p><strong>WP Mail Logger: </strong>';
    echo __('No events were found with this log_id', 'rtm-mail');
    echo '</p>';
    echo '</div>';
}