<?php

namespace RtmMail;

use RtmMail\Mailing\Providers\GmailHandler;
use RtmMail\Mailing\Providers\MailgunHandler;
use RtmMail\Mailing\Providers\OtherHandler;

/**
 * Settings - handles every user interaction for the settings page
 */
class MailSMTP extends AbstractPage
{
    protected $slug = 'mailsmtp';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        // Check if the user is on the settings page
        if ($this->page_check()) {
            // Check for save settings post request
            if (isset($_POST['save_settings'])) {
                // Verify if the post is from the right source
                if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_save_smtp')) {
                    $encryption_key = get_option('rtm_mail_smtp_key', false);
                    if (empty($encryption_key)) {
                        $encryption_key = wp_salt();
                        update_option('rtm_mail_smtp_key', $encryption_key);
                    }

                    $smtp_settings = [];
                    $smtp_settings['smtp_enabled'] = isset($_POST['smtp_enabled']) ? filter_var($_POST['smtp_enabled'], FILTER_VALIDATE_BOOLEAN) : false;
                    $smtp_settings['smtp_provider'] = $_POST['smtp_provider'];

                    $settings = $_POST['smtp_setting'];
                    foreach ($settings as $type => $setting) {
                        foreach ($setting as $key => $option) {
                            if (strpos($key, 'password') !== false) {
                                $settings[$type][$key] = Cryptor::Encrypt($option, $encryption_key);
                            }
                        }
                    }
                    $smtp_settings['smtp_settings'] = $settings;
                    // Save to option table
                    update_option('rtm_mail_smtp_settings', $smtp_settings);

                    // Send notification
                    echo '<div class="notice notice-success"> ';
                    echo '<p><strong>WP Mail Logger: </strong>';
                    echo __('Settings successfully saved!', 'rtm-mail');
                    echo '</p>';
                    echo '</div>';
                }
            }

            if (isset($_POST['get_gmail_token'])) {
                if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_save_smtp')) {
                    // Send notification
                    (new GmailHandler())->getAuthUrl();
                }
            }
        }
    }

    /**
     * display - Displays the page view for the user
     */
    public function display()
    {
        // Check if user is on the details page
        if ($this->page_check()) {
            global $handlers;

            $handlers = [
                'gmail' => [
                    'title' => __('Gmail SMTP'),
                    'image' => 'gmail-logo.png',
                    'fields' => GmailHandler::getFields()
                ],
                'other' => [
                    'title' => __('Default SMTP'),
                    'image' => '',
                    'fields' => OtherHandler::getFields()
                ],
            ];

            // load in the details view for the user
            require __DIR__ . '/Views/' . $this->slug . '.php';
        }
    }
}
