<?php

namespace RtmMail;


use RtmMail\Helpers\EventHelper;

/**
 * Events - handles every user interaction for the events page
 */
class Events extends AbstractPage
{
    protected $slug = 'events';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * handle_requests - every page can handle their requests (post/get)
     */
    public function handle_requests()
    {
        // Check for action
        if (isset($_POST['action'])) {
            if ($_POST['action'] === 'clear_events') {
                // check wp nonce
                if (wp_verify_nonce($_POST['_wpnonce'], 'rtm_mail_clear_events')) {
                    $settings = get_option('rtm_mail_settings');
                    $clear_deleted_only = $settings['clear_deleted_events'] ?? true;
                    EventHelper::delete($clear_deleted_only);
                }
            }
        }
    }

    /**
     * display - Displays the page view for the user
     */
    public function display()
    {
        // Check if user is on the details page
        if ($this->page_check()) {
            // load in the details view for the user
            require __DIR__ . '/Views/' . $this->slug . '.php';
        }
    }
}
