<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class VerificationAttemptContext extends InstanceContext {
    /**
     * Initialize the VerificationAttemptContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid Verification Attempt Sid.
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sid' => $sid, ];

        $this->uri = '/Attempts/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the VerificationAttemptInstance
     *
     * @return VerificationAttemptInstance Fetched VerificationAttemptInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): VerificationAttemptInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new VerificationAttemptInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Verify.V2.VerificationAttemptContext ' . \implode(' ', $context) . ']';
    }
}