<?php
 namespace RtmMail; use PHPMailer\PHPMailer\PHPMailer; use RtmMail\Helpers\LogHelper; use Twilio\Exceptions\ConfigurationException; use Twilio\Exceptions\TwilioException; use Twilio\Rest\Client; class Catcher { public function catch_mail($args) { if (empty($args['headers']) || substr($args["headers"][0], 0, 2) !== 'Id') { $settings = get_option('rtm_mail_settings'); if (is_string($args['to'])) { $args['to'] = str_replace(',', ';', $args['to']); $recipients = []; foreach (explode(';', $args['to']) as $recipient) { $recipients[] = str_replace(' ', '', $recipient); } $args['to'] = $recipients; } $args['headers'] = $args['headers'] ?? []; $args['headers'] = is_string($args['headers']) ? explode("\n", str_replace("\\r\\n", "\n", $args['headers'])) : $args['headers']; $args['backtrace'] = $this->get_backtrace(); $settings['addresses'] = $settings['addresses'] ?? []; foreach ($settings['addresses'] as $address) { $email_address = $address['address']; $email_type = $address['type']; if (!empty($email_address)) { if ($email_type === 'recipient') { $args['to'][] = $email_address; } else { $args['headers'][] = ucfirst($email_type) . ': ' . $email_address; } } } $mail_data = $this->format($args); $log_id = LogHelper::save($mail_data); do_action('rtmmail_mail_caught', $log_id); $block_mails = $settings['block_mails'] ?? false; if ($block_mails) { $args['to'] = []; $args['headers'] = []; } else { $smtp_settings = get_option('rtm_mail_smtp_settings'); $smtp_enabled = isset($smtp_settings['smtp_enabled']) && filter_var($smtp_settings['smtp_enabled'], FILTER_VALIDATE_BOOLEAN); if ($smtp_enabled) { self::send_smtp($log_id, $mail_data); } else { LogHelper::update($log_id, ['status' => 'sent', 'sent' => date('Y-m-d H:i:s', time())]); array_unshift($args['headers'], "Id: " . $log_id); } } } return $args; } public function mail_error($error) { if (!empty($error->error_data['wp_mail_failed']['headers'])) { $log_id = (int)$error->error_data['wp_mail_failed']['headers']['Id']; LogHelper::update($log_id, ['status' => 'failed', 'sent' => null]); self::send_text_message($log_id); do_action('rtmmail_send_failed', $log_id, $error->errors['wp_mail_failed'][0]); } } public static function send_mail($log_id, $single_address = null) { $mail_log = LogHelper::get([ 'post_per_page' => null, 'where' => [ 'id' => [ 'type' => '=', 'value' => $log_id, ] ] ]); $mail_log = $mail_log[0] ?? null; if ($mail_log == null) { return; } $smtp_settings = get_option('rtm_mail_smtp_settings'); $smtp_enabled = isset($smtp_settings['smtp_enabled']) && filter_var($smtp_settings['smtp_enabled'], FILTER_VALIDATE_BOOLEAN); if ($smtp_enabled) { return self::send_smtp($log_id, $mail_log, $single_address); } else { $mail_data = []; $mail_data['subject'] = $mail_log['subject']; $mail_data['to'] = $mail_log['receiver']; $mail_data['message'] = $mail_log['body']; $mail_data['headers'] = []; $mail_data['receiver_status'] = $mail_log['receiver_status']; if (!empty($mail_log['cc'])) { foreach ($mail_log['cc'] as $cc_address) { if (!empty($cc_address)) { $mail_data['headers'][] = 'Cc: ' . $cc_address; } } } if (!empty($mail_log['bcc'])) { foreach ($mail_log['bcc'] as $bcc_address) { if (!empty($bcc_address)) { $mail_data['headers'][] = 'Bcc: ' . $bcc_address; } } } if (!empty($mail_log['headers'])) { foreach ($mail_log['headers'] as $header_key => $header_value) { if (!empty($header_value)) { $mail_data['headers'][] = ucfirst($header_key) . ': ' . $header_value; } } } array_unshift($mail_data['headers'], "Id: " . $log_id); $mail_data['attachments'] = []; if (!empty($mail_log['attachments'])) { foreach ($mail_log['attachments'] as $attachment) { if (!empty($attachment)) { $mail_data['attachments'][] = $attachment; } } } if ($single_address === null) { $success = []; $receiver_status = []; foreach ($mail_data['to'] as $to_address) { $mail_data['message'] .= '<img src="' . self::get_track_url($log_id, $to_address) . '" style="display:none;" />'; $mail_sent = wp_mail($to_address, $mail_data['subject'], $mail_data['message'], $mail_data['headers'], $mail_data['attachments']); $receiver_status[$to_address] = ['opened' => false, 'sent' => $mail_sent]; $success[] = $mail_sent; } LogHelper::update($log_id, ['receiver_status' => json_encode($receiver_status)]); if (in_array(true, $success, true)) { LogHelper::update($log_id, ['status' => 'sent', 'sent' => date('Y-m-d H:i:s', time())]); do_action('rtmmail_send_success', $log_id); return 'success'; } else { LogHelper::update($log_id, ['status' => 'failed', 'sent' => null]); return __('Failed sending email, check the debug logs for more info!', 'rtm-mail'); } } else { $mail_data['message'] .= '<img src="' . self::get_track_url($log_id, $single_address) . '" style="display:none;" />'; $mail_sent = wp_mail($single_address, $mail_data['subject'], $mail_data['message'], $mail_data['headers'], $mail_data['attachments']); $mail_data['receiver_status'][$single_address] = ['opened' => false, 'sent' => $mail_sent]; LogHelper::update($log_id, ['receiver_status' => json_encode($mail_data['receiver_status'])]); if ($mail_sent) { return 'success'; } else { return __('Failed sending email, check the debug logs for more info!', 'rtm-mail'); } } } } private static function send_smtp($log_id, $mail_data, $single_address = null) { $settings = get_option('rtm_mail_settings'); $sender_options = $settings['sender_options'] ?? null; $sender_mail = ($sender_options != null && !empty($sender_options['address'])) ? $sender_options['address'] : get_option('admin_email'); $sender_title = ($sender_options != null && !empty($sender_options['title'])) ? $sender_options['title'] : get_bloginfo('name'); $encryption_key = get_option('rtm_mail_smtp_key', false); $smtp_settings = get_option('rtm_mail_smtp_settings'); $smtp_enabled = $smtp_settings['smtp_enabled'] ?? false; if (!$smtp_enabled) { return __('SMTP is not enabled'); } $host = $smtp_settings['host'] ?? ''; $encryption = $smtp_settings['encryption'] ?? 'none'; $port = $smtp_settings['port'] ?? 0; $authentication = $smtp_settings['authentication'] ?? true; $username = $smtp_settings['username'] ?? ''; $password = isset($smtp_settings['password']) ? Cryptor::Decrypt($smtp_settings['password'], $encryption_key) : ''; require_once ABSPATH . WPINC . '/PHPMailer/PHPMailer.php'; require_once ABSPATH . WPINC . '/PHPMailer/SMTP.php'; require_once ABSPATH . WPINC . '/PHPMailer/Exception.php'; $mail = new PHPMailer(true); $mail->CharSet = get_bloginfo('charset'); $mail->IsSMTP(); $mail->ContentType = $mail_data['headers']['content-type']; $mail->IsHTML($mail_data['headers']['content-type'] === 'text/html'); $mail->Host = $host; $mail->Port = $port; if ($encryption !== 'none') { $mail->SMTPSecure = $encryption; } if ($authentication) { $mail->SMTPAuth = true; $mail->Username = $username; $mail->Password = $password; } $success = []; $receiver_status = $mail_data['receiver_status']; if ($single_address === null) { foreach ($mail_data['receiver'] as $to_address) { if (!empty($to_address)) { try { $mail->SetFrom($sender_mail, $sender_title); $mail->AddAddress($to_address); foreach($mail_data['cc'] as $cc_address) { if (!empty($cc_address)) { $mail->AddCC($cc_address); } } foreach($mail_data['bcc'] as $bcc_address) { if (!empty($bcc_address)) { $mail->AddBcc($bcc_address); } } $mail_data['body'] .= '<img src="' . self::get_track_url($log_id, $to_address) . '" style="display:none;" />'; $mail->Subject = $mail_data['subject']; $mail->Body = $mail_data['body']; foreach ($mail_data['attachments'] as $attachment) { $mail->addAttachment($attachment, basename($attachment)); } $mail->Timeout = 10; $mail->Send(); $mail->ClearAllRecipients(); $receiver_status[$to_address] = ['opened' => false, 'sent' => true]; $success[] = true; } catch(\Exception $ex) { do_action('rtmmail_send_failed', $log_id, $mail->ErrorInfo); $receiver_status[$to_address] = ['opened' => false, 'sent' => false]; $success[] = false; } } } } else { try { $mail->SetFrom($sender_mail, $sender_title); $mail->AddAddress($single_address); foreach($mail_data['cc'] as $cc_address) { if (!empty($cc_address)) { $mail->AddCC($cc_address); } } foreach($mail_data['bcc'] as $bcc_address) { if (!empty($bcc_address)) { $mail->AddBcc($bcc_address); } } $mail_data['body'] .= '<img src="' . self::get_track_url($log_id, $single_address) . '" style="display:none;" />'; $mail->Subject = $mail_data['subject']; $mail->Body = $mail_data['body']; foreach ($mail_data['attachments'] as $attachment) { $mail->addAttachment($attachment, basename($attachment)); } $mail->Timeout = 10; $mail->Send(); $mail->ClearAllRecipients(); $receiver_status[$single_address] = ['opened' => false, 'sent' => true]; $success[] = true; } catch(\Exception $ex) { do_action('rtmmail_send_failed', $log_id, $mail->ErrorInfo); $receiver_status[$single_address] = ['opened' => false, 'sent' => false]; $success[] = false; } } LogHelper::update($log_id, ['receiver_status' => json_encode($receiver_status)]); if (in_array(true, $success, true)) { LogHelper::update($log_id, ['status' => 'sent', 'sent' => date('Y-m-d H:i:s', time())]); do_action('rtmmail_send_success', $log_id); return 'success'; } else { LogHelper::update($log_id, ['status' => 'failed', 'sent' => null]); do_action('rtmmail_send_failed', $log_id, $mail->ErrorInfo); self::send_text_message($log_id); return $mail->ErrorInfo; } } public function send_caught_logs() { $caught_logs = LogHelper::get([ 'post_per_page' => null, 'where' => [ 'status' => [ 'type' => '=', 'value' => 'caught', ] ] ]); if (isset($caught_logs[0])) { foreach ($caught_logs as $log) { self::send_mail($log['id']); } } } private function format($args) { $settings = get_option('rtm_mail_settings'); $sender_options = $settings['sender_options'] ?? null; $formatted_data = []; $formatted_data['sender'] = ($sender_options != null && !empty($sender_options['address'])) ? $sender_options['address'] : get_option('admin_email'); $sender_title = ($sender_options != null && !empty($sender_options['title'])) ? $sender_options['title'] : get_bloginfo('name'); $formatted_data['receiver'] = []; $formatted_data['cc'] = []; $formatted_data['bcc'] = []; $formatted_data['subject'] = $args['subject']; $formatted_data['body'] = stripslashes(htmlspecialchars_decode($args['message'])); $formatted_data['attachments'] = []; $formatted_data['headers'] = []; $formatted_data['backtrace'] = $args['backtrace'] ?? []; $formatted_data['created'] = date('Y-m-d H:i:s', time()); $formatted_data['receiver_status'] = []; $args['to'] = $args['to'] ?? []; $args['headers'] = $args['headers'] ?? []; $args['attachments'] = $args['attachments'] ?? []; foreach ($args['to'] as $receiver_mail) { if (!empty($receiver_mail)) { $formatted_data['receiver'][] = $receiver_mail; $formatted_data['receiver_status'][$receiver_mail] = [ 'opened' => false, 'sent' => false, ]; } } foreach ($args['headers'] as $header) { if (strpos(strtolower($header), 'from:') !== false) { $from_email = trim(str_replace('from: ', '', strtolower($header)), '\'"'); if (!empty($from_email)) { $formatted_data['sender'] = $from_email; } } else if (strpos(strtolower($header), 'bcc:') !== false) { $bcc_email = trim(str_replace('bcc: ', '', strtolower($header)), '\'"'); if (!empty($bcc_email)) { $formatted_data['bcc'][] = $bcc_email; } } else if (strpos(strtolower($header), 'cc:') !== false) { $cc_email = trim(str_replace('cc: ', '', strtolower($header)), '\'"'); if (!empty($cc_email)) { $formatted_data['cc'][] = $cc_email; } } else { $header_data = explode(':', str_replace(' ', '', strtolower($header))); $formatted_data['headers'][$header_data[0]] = $header_data[1] ?? ''; } } $formatted_data['headers']['from'] = $sender_title . ' <' . $formatted_data['sender'] . '>'; $upload = wp_upload_dir(); $upload_dir = $upload['basedir'] . '/rtm-mail/attachments'; if (!is_dir($upload_dir)) { mkdir($upload_dir, 0755); } foreach ($args['attachments'] as $attachment) { $date = date('Y_m_d H_i_s', time()); $file_name = substr($attachment, strrpos($attachment, '/')); $extension = explode('.', $file_name)[1]; $new_file = $upload_dir . str_replace('.' . $extension, '', $file_name) . '-' . str_replace(' ', '', $date) . '.' . $extension; if (copy($attachment, $new_file)) { $formatted_data['attachments'][] = $new_file; } else { printf(__('WP Mail Logger FATAL ERROR: Couldn\'t copy file %s to directory. Attachment is not added to logged mail', 'rtm-mail'), $new_file); } } return $formatted_data; } public function set_read_request(&$wp) { if (isset($wp->query_vars['rtm_mail_read'])) { set_query_var('log_id', $wp->query_vars['log_id']); set_query_var('address', $wp->query_vars['address']); $log_id = get_query_var('log_id', null); $address = get_query_var('address', null); if ($log_id !== null && $address !== null) { $mail_log = LogHelper::get([ 'post_per_page' => null, 'where' => [ 'id' => [ 'type' => '=', 'value' => $log_id, ] ] ]); if (isset($mail_log[0])) { $receiver_status = $mail_log[0]['receiver_status']; foreach ($receiver_status as $status) { if (isset($receiver_status[$address]) && !$status['opened']) { $receiver_status[$address]['opened'] = true; } } LogHelper::update($log_id, [ 'receiver_status' => json_encode($receiver_status), ]); } } } } private static function get_track_url($log_id, $address) { return home_url() . '/trackmail/' . $log_id . '/' . $address; } private static function send_text_message($log_id) { $settings = get_option('rtm_mail_settings'); $sms_enabled = $settings['sms_enabled'] ?? false; $twilio_settings = $settings['twilio_settings'] ?? null; if ($sms_enabled && $twilio_settings !== null) { try { $client = new Client($twilio_settings['sid'], $twilio_settings['auth']); $log_link = get_admin_url() . 'admin.php?page=rtm-mail-details&log_id=' . $log_id; try { $client->messages->create($twilio_settings['phone'], [ 'from' => $twilio_settings['number'], 'body' => sprintf(__('There was an error sending a mail log (%s) caught by WP Mail Logger', 'rtm-mail'), $log_link), ]); } catch (TwilioException $tex) { do_action('rtmmail_text_message_failed', $log_id, $tex); } } catch (ConfigurationException $cex) { do_action('rtmmail_text_message_failed', $log_id, $cex); } } } private function get_backtrace() { $result = []; $trace = array_reverse(debug_backtrace()); array_pop($trace); foreach ($trace as $trace_line) { if (!isset($trace_line['class']) || $trace_line['class'] !== 'WP_Hook') { $call = isset($trace_line['class']) ? $trace_line['class'] . $trace_line['type'] . $trace_line['function'] : $trace_line['function']; if (strpos($call, 'require') === false && strpos($call, 'include') === false) { $result[] = [ 'call' => $call, 'line' => $trace_line['line'], 'file' => $trace_line['file'] ]; } } } return $result; } } 