<?php
 use RtmMail\EventsTable; $events_table = new EventsTable(); $events_table->prepare_items(); ?>

<div class="wrap" id="rtm-mail">
    <?php \RtmMail\Core::render_page_header('events'); ?>

    <div class="rtm-mail-page-content">
        <div class="rtm-page-info">
            <p class="heading rtm-heading"><?php echo __('Events', 'rtm-mail'); ?></p>
            <p class="rtm-heading-description"><?php echo __('On this page you can check every event that happened in the WP Mail Logger Plugin. Here you can see what logs were sent, edited or deleted. You can also find emails that failed to sent and the error.', 'rtm-mail'); ?></p>
            <h1 class="notice-header"><?php echo __('Events', 'rtm-mail'); ?></h1>
        </div>
        <hr>
        <div class="rtm-mail-page-events">
            <form method="get">
                <input type="hidden" name="page" value="rtm-mail-events"/>
                <div class="table-top-box">
                    <div class="date-box">
                        <input type="text" id="rtm-date-range" name="date"
                               placeholder="<?php echo __('Select a date range', 'rtm-mail'); ?>"/>
                        <?php submit_button(__('Filter', 'rtm-mail'), '', 'filter-date-range', false, ['id' => 'filter-date-range']); ?>
                    </div>
                    <?php $events_table->search_box(__('Search', 'rtm-mail'), 'search_id'); ?>
                </div>
                <?php $events_table->display(); ?>
            </form>
        </div>
    </div>
    <div class="modal log-action-delete-modal" id="modal_clear_events">
        <div class="modal-container">
            <div class="modal-header" style="display: block!important;">
                <i class="fas fa-times modal-close" data-id="clear_events"></i>
            </div>
            <div class="modal-content">
                <form method="post">
                    <input type="hidden" name="_wpnonce"
                           value="<?php echo esc_attr(wp_create_nonce('rtm_mail_clear_events')); ?>"/>
                    <input type="hidden" id="action_type" name="action" value="clear_events"/>
                    <p>
                        <strong class="action_message"><?php echo __('Are you sure you want to clear debug events?', 'rtm-mail'); ?></strong>
                    </p>
                    <button type="submit" name="clear_button" class="button button-delete"
                            id="confirm_action"><?php echo __('Clear', 'rtm-mail'); ?></button>
                </form>
            </div>
        </div>
    </div>
</div>
