<?php

global $migration_obj;

class InitialMigration implements MigrationInterface
{

    public function get_name() {
        return 'initial';
    }

    public function migrate()
    {
        global $wpdb;

        $this->init_course_table($wpdb);
    }

    public function rollback()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'course_data';
        $sql = "ALTER TABLE {$table_name} DROP FOREIGN KEY FK_course_data_posts; DROP TABLE {$table_name};";

        dbDelta($sql);
    }

    public function init_course_table($wpdb)
    {
        $table_name = $wpdb->prefix . 'course_data';
        $coll = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE {$table_name} (
                id bigint UNSIGNED NOT NULL AUTO_INCREMENT,
                product_id bigint UNSIGNED UNIQUE NOT NULL,
                start_date datetime DEFAULT '1970-01-01 00:00:00' NOT NULL,
                end_date datetime DEFAULT '1970-01-01 00:00:00' NOT NULL,
                day_of_week longtext NOT NULL,
                skip_dates longtext NULL,
		        PRIMARY KEY (id),
		        CONSTRAINT FK_course_data_posts FOREIGN KEY (product_id) REFERENCES {$wpdb->prefix}posts(ID)
            ) {$coll};";

        dbDelta($sql);
    }

}
$migration_obj = new InitialMigration();
