<?php

class CourseDataMetaBox
{

    public function __construct()
    {
        add_action('rwmb_meta_boxes', [$this, 'add_meta_box']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_scripts']);
    }

    public function enqueue_scripts()
    {
        $screen = get_current_screen();
        if ($screen && $screen->base === 'post' && $screen->id === 'product') {
            $basepath = ACADEMIA_EXTENSIONS_ID . DIRECTORY_SEPARATOR;
            wp_enqueue_script('litepicker', plugins_url($basepath . 'assets/js/litepicker/litepicker.js'), [], '2.0.8-rtm');
            wp_enqueue_script('litepicker-multiselect', plugins_url($basepath . 'assets/js/litepicker/plugins/multiselect.js'), ['litepicker'], '2.0.8-rtm');
            wp_enqueue_script('litepicker-mobilefriendly', plugins_url($basepath . 'assets/js/litepicker/plugins/mobilefriendly.js'), ['litepicker'], '2.0.8-rtm');
            wp_enqueue_script('litepicker-ranges', plugins_url($basepath . 'assets/js/litepicker/plugins/ranges.js'), ['litepicker'], '2.0.8-rtm');
            wp_enqueue_script('litepicker-keyboardnav', plugins_url($basepath . 'assets/js/litepicker/plugins/keyboardnav.js'), ['litepicker'], '2.0.8-rtm');

            wp_enqueue_script('taalthuis-course-dates', plugins_url($basepath . 'assets/js/course-dates.js'), ['litepicker', 'litepicker-multiselect'], '1.0.0', true);
            wp_enqueue_style('taalthuis-course-dates', plugins_url($basepath . 'assets/css/course-dates.css'), [], '1.0.0');

        }
    }

    public function add_meta_box($meta_boxes)
    {
        add_meta_box(
            'tt_course_data',
            __('Course Data', ' taalthuis'),
            [$this, 'course_meta_html'],
            'product',
            'normal',
            'high'
        );
    }

    /**
     * Render the meta's html.
     * @param $post
     */
    public function course_meta_html($post)
    {
        $session = wc_get_product($post->ID)->get_attribute('pa_session');
        $course_data = tt_get_course_by_product($post->ID);

        if ($course_data) {
            wp_localize_script('taalthuis-course-dates', 'initialDates', [
                'start' => $course_data->get_start_date()->format('Y-m-d'),
                'end' => $course_data->get_end_date()->format('Y-m-d'),
                'skip' => array_map(fn($d) => $d->format('Y-m-d'), $course_data->get_skip_dates())
            ]);
        }

        ?>
        <div class="row">
            <div id="course-data-inputs" class="course-data-inputs">
                <label>
                    Start Date
                    <input id="course-start" class="form-control" type="text">
                </label>
                <label>
                    End Date
                    <input id="course-end" class="form-control" type="text">
                </label>
                <label>
                    Day of week
                    <input id="course-dow" class="form-control disabled" type="text">
                </label>
                <label>
                    Skip days
                    <input id="course-skipdates" name="skip_dates" type="text" class="form-control disabled"
                           placeholder="Click to select days to skip"/>
                </label>
                <label>
                    Notify customers of this change
                    <input id="course-notify-users" name="course_notify_users" class="form-control" type="checkbox"/>
                </label>
                <div id="litepicker-container" class="litepicker-container"></div>
            </div>

            <div id="tt_course_data_preview">
                <h3>Preview text</h3>
                <p>
                    <strong>Dates: </strong><span id="preview_day_of_week"></span> <?= $session ?>

                    <span id="preview_dates"></span>
                </p>
            </div>
        </div>
        <?php
    }

}

new CourseDataMetaBox();