/*!
 * 
 * plugins/mobilefriendly.js
 * Litepicker v2.0.8-rtm (https://github.com/wakirin/Litepicker)
 * Package: litepicker (https://www.npmjs.com/package/litepicker)
 * License: MIT (https://github.com/wakirin/Litepicker/blob/master/LICENCE.md)
 * Copyright 2019-2021 Rinat G.
 *     
 * Hash: 3fce70cf8a9e3288bd35
 * 
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/plugins/mobilefriendly/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/css-loader/dist/cjs.js!./src/plugins/mobilefriendly/style.css":
/*!************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./src/plugins/mobilefriendly/style.css ***!
  \************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, ":root {\n  --litepicker-mobilefriendly-backdrop-color-bg: #000;\n}\n\n.litepicker-backdrop {\n  display: none;\n  background-color: var(--litepicker-mobilefriendly-backdrop-color-bg);\n  opacity: 0.3;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n}\n\n.litepicker-open {\n  overflow: hidden;\n}\n\n.litepicker.mobilefriendly[data-plugins*=\"mobilefriendly\"] {\n  transform: translate(-50%, -50%);\n  font-size: 1.1rem;\n  --litepicker-container-months-box-shadow-color: #616161;\n}\n.litepicker.mobilefriendly-portrait {\n  --litepicker-day-width: 13.5vw;\n  --litepicker-month-width: calc(var(--litepicker-day-width) * 7);\n}\n.litepicker.mobilefriendly-landscape {\n  --litepicker-day-width: 5.5vw;\n  --litepicker-month-width: calc(var(--litepicker-day-width) * 7);\n}\n\n.litepicker[data-plugins*=\"mobilefriendly\"] .container__months {\n  overflow: hidden;\n}\n\n.litepicker.mobilefriendly[data-plugins*=\"mobilefriendly\"] .container__months .month-item-header {\n  height: var(--litepicker-day-width);\n}\n\n.litepicker.mobilefriendly[data-plugins*=\"mobilefriendly\"] .container__days > div {\n  height: var(--litepicker-day-width);\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n\n\n.litepicker[data-plugins*=\"mobilefriendly\"] .container__months .month-item {\n  transform-origin: center;\n}\n\n.litepicker[data-plugins*=\"mobilefriendly\"] .container__months .month-item.touch-target-next {\n  animation-name: lp-bounce-target-next;\n  animation-duration: .5s;\n  animation-timing-function: ease;\n}\n\n.litepicker[data-plugins*=\"mobilefriendly\"] .container__months .month-item.touch-target-prev {\n  animation-name: lp-bounce-target-prev;\n  animation-duration: .5s;\n  animation-timing-function: ease;\n}\n\n@keyframes lp-bounce-target-next {\n  from {\n    transform: translateX(100px) scale(0.5);\n  }\n  to {\n    transform: translateX(0px) scale(1);\n  }\n}\n\n@keyframes lp-bounce-target-prev {\n  from {\n    transform: translateX(-100px) scale(0.5);\n  }\n  to {\n    transform: translateX(0px) scale(1);\n  }\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/api.js":
/*!*****************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/api.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
// eslint-disable-next-line func-names
module.exports = function (useSourceMap) {
  var list = []; // return the list of modules as css string

  list.toString = function toString() {
    return this.map(function (item) {
      var content = cssWithMappingToString(item, useSourceMap);

      if (item[2]) {
        return "@media ".concat(item[2], " {").concat(content, "}");
      }

      return content;
    }).join('');
  }; // import a list of modules into the list
  // eslint-disable-next-line func-names


  list.i = function (modules, mediaQuery, dedupe) {
    if (typeof modules === 'string') {
      // eslint-disable-next-line no-param-reassign
      modules = [[null, modules, '']];
    }

    var alreadyImportedModules = {};

    if (dedupe) {
      for (var i = 0; i < this.length; i++) {
        // eslint-disable-next-line prefer-destructuring
        var id = this[i][0];

        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }

    for (var _i = 0; _i < modules.length; _i++) {
      var item = [].concat(modules[_i]);

      if (dedupe && alreadyImportedModules[item[0]]) {
        // eslint-disable-next-line no-continue
        continue;
      }

      if (mediaQuery) {
        if (!item[2]) {
          item[2] = mediaQuery;
        } else {
          item[2] = "".concat(mediaQuery, " and ").concat(item[2]);
        }
      }

      list.push(item);
    }
  };

  return list;
};

function cssWithMappingToString(item, useSourceMap) {
  var content = item[1] || ''; // eslint-disable-next-line prefer-destructuring

  var cssMapping = item[3];

  if (!cssMapping) {
    return content;
  }

  if (useSourceMap && typeof btoa === 'function') {
    var sourceMapping = toComment(cssMapping);
    var sourceURLs = cssMapping.sources.map(function (source) {
      return "/*# sourceURL=".concat(cssMapping.sourceRoot || '').concat(source, " */");
    });
    return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
  }

  return [content].join('\n');
} // Adapted from convert-source-map (MIT)


function toComment(sourceMap) {
  // eslint-disable-next-line no-undef
  var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
  var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
  return "/*# ".concat(data, " */");
}

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js":
/*!****************************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isOldIE = function isOldIE() {
  var memo;
  return function memorize() {
    if (typeof memo === 'undefined') {
      // Test for IE <= 9 as proposed by Browserhacks
      // @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
      // Tests for existence of standard globals is to allow style-loader
      // to operate correctly into non-standard environments
      // @see https://github.com/webpack-contrib/style-loader/issues/177
      memo = Boolean(window && document && document.all && !window.atob);
    }

    return memo;
  };
}();

var getTarget = function getTarget() {
  var memo = {};
  return function memorize(target) {
    if (typeof memo[target] === 'undefined') {
      var styleTarget = document.querySelector(target); // Special case to return head of iframe instead of iframe itself

      if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
        try {
          // This will throw an exception if access to iframe is blocked
          // due to cross-origin restrictions
          styleTarget = styleTarget.contentDocument.head;
        } catch (e) {
          // istanbul ignore next
          styleTarget = null;
        }
      }

      memo[target] = styleTarget;
    }

    return memo[target];
  };
}();

var stylesInDom = [];

function getIndexByIdentifier(identifier) {
  var result = -1;

  for (var i = 0; i < stylesInDom.length; i++) {
    if (stylesInDom[i].identifier === identifier) {
      result = i;
      break;
    }
  }

  return result;
}

function modulesToDom(list, options) {
  var idCountMap = {};
  var identifiers = [];

  for (var i = 0; i < list.length; i++) {
    var item = list[i];
    var id = options.base ? item[0] + options.base : item[0];
    var count = idCountMap[id] || 0;
    var identifier = "".concat(id, " ").concat(count);
    idCountMap[id] = count + 1;
    var index = getIndexByIdentifier(identifier);
    var obj = {
      css: item[1],
      media: item[2],
      sourceMap: item[3]
    };

    if (index !== -1) {
      stylesInDom[index].references++;
      stylesInDom[index].updater(obj);
    } else {
      stylesInDom.push({
        identifier: identifier,
        updater: addStyle(obj, options),
        references: 1
      });
    }

    identifiers.push(identifier);
  }

  return identifiers;
}

function insertStyleElement(options) {
  var style = document.createElement('style');
  var attributes = options.attributes || {};

  if (typeof attributes.nonce === 'undefined') {
    var nonce =  true ? __webpack_require__.nc : undefined;

    if (nonce) {
      attributes.nonce = nonce;
    }
  }

  Object.keys(attributes).forEach(function (key) {
    style.setAttribute(key, attributes[key]);
  });

  if (typeof options.insert === 'function') {
    options.insert(style);
  } else {
    var target = getTarget(options.insert || 'head');

    if (!target) {
      throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
    }

    target.appendChild(style);
  }

  return style;
}

function removeStyleElement(style) {
  // istanbul ignore if
  if (style.parentNode === null) {
    return false;
  }

  style.parentNode.removeChild(style);
}
/* istanbul ignore next  */


var replaceText = function replaceText() {
  var textStore = [];
  return function replace(index, replacement) {
    textStore[index] = replacement;
    return textStore.filter(Boolean).join('\n');
  };
}();

function applyToSingletonTag(style, index, remove, obj) {
  var css = remove ? '' : obj.media ? "@media ".concat(obj.media, " {").concat(obj.css, "}") : obj.css; // For old IE

  /* istanbul ignore if  */

  if (style.styleSheet) {
    style.styleSheet.cssText = replaceText(index, css);
  } else {
    var cssNode = document.createTextNode(css);
    var childNodes = style.childNodes;

    if (childNodes[index]) {
      style.removeChild(childNodes[index]);
    }

    if (childNodes.length) {
      style.insertBefore(cssNode, childNodes[index]);
    } else {
      style.appendChild(cssNode);
    }
  }
}

function applyToTag(style, options, obj) {
  var css = obj.css;
  var media = obj.media;
  var sourceMap = obj.sourceMap;

  if (media) {
    style.setAttribute('media', media);
  } else {
    style.removeAttribute('media');
  }

  if (sourceMap && typeof btoa !== 'undefined') {
    css += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))), " */");
  } // For old IE

  /* istanbul ignore if  */


  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    while (style.firstChild) {
      style.removeChild(style.firstChild);
    }

    style.appendChild(document.createTextNode(css));
  }
}

var singleton = null;
var singletonCounter = 0;

function addStyle(obj, options) {
  var style;
  var update;
  var remove;

  if (options.singleton) {
    var styleIndex = singletonCounter++;
    style = singleton || (singleton = insertStyleElement(options));
    update = applyToSingletonTag.bind(null, style, styleIndex, false);
    remove = applyToSingletonTag.bind(null, style, styleIndex, true);
  } else {
    style = insertStyleElement(options);
    update = applyToTag.bind(null, style, options);

    remove = function remove() {
      removeStyleElement(style);
    };
  }

  update(obj);
  return function updateStyle(newObj) {
    if (newObj) {
      if (newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap) {
        return;
      }

      update(obj = newObj);
    } else {
      remove();
    }
  };
}

module.exports = function (list, options) {
  options = options || {}; // Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
  // tags it will allow on a page

  if (!options.singleton && typeof options.singleton !== 'boolean') {
    options.singleton = isOldIE();
  }

  list = list || [];
  var lastIdentifiers = modulesToDom(list, options);
  return function update(newList) {
    newList = newList || [];

    if (Object.prototype.toString.call(newList) !== '[object Array]') {
      return;
    }

    for (var i = 0; i < lastIdentifiers.length; i++) {
      var identifier = lastIdentifiers[i];
      var index = getIndexByIdentifier(identifier);
      stylesInDom[index].references--;
    }

    var newLastIdentifiers = modulesToDom(newList, options);

    for (var _i = 0; _i < lastIdentifiers.length; _i++) {
      var _identifier = lastIdentifiers[_i];

      var _index = getIndexByIdentifier(_identifier);

      if (stylesInDom[_index].references === 0) {
        stylesInDom[_index].updater();

        stylesInDom.splice(_index, 1);
      }
    }

    lastIdentifiers = newLastIdentifiers;
  };
};

/***/ }),

/***/ "./src/plugins/mobilefriendly/index.js":
/*!*********************************************!*\
  !*** ./src/plugins/mobilefriendly/index.js ***!
  \*********************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./style.css */ "./src/plugins/mobilefriendly/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_css__WEBPACK_IMPORTED_MODULE_0__);

Litepicker.add('mobilefriendly', {
  init: function init(picker) {
    var options = picker.options;
    Object.defineProperties(picker, {
      xTouchDown: {
        value: null,
        writable: true
      },
      yTouchDown: {
        value: null,
        writable: true
      },
      touchTargetMonth: {
        value: null,
        writable: true
      }
    });
    var supportsPassive = false;

    try {
      var opts = Object.defineProperty({}, 'passive', {
        get: function get() {
          supportsPassive = true;
        }
      });
      window.addEventListener("testPassive", null, opts);
      window.removeEventListener("testPassive", null, opts);
    } catch (e) {}

    function isMobile() {
      var isPortrait = getOrientation() === 'portrait';
      return window.matchMedia("(max-device-".concat(isPortrait ? 'width' : 'height', ": ", 480, "px)")).matches;
    }

    function getOrientation() {
      var orientation;

      if ('orientation' in window.screen && 'type' in window.screen.orientation) {
        orientation = window.screen.orientation.type.replace(/\-\w+$/, '');
      } else if (window.matchMedia('(orientation: portrait)').matches) {
        orientation = 'portrait';
      } else {
        orientation = 'landscape';
      }

      return orientation;
    }

    function fitNumberOfMonths() {
      if (getOrientation() === 'portrait') {
        picker.options.numberOfMonths = 1;
        picker.options.numberOfColumns = 1;
      } else {
        picker.options.numberOfMonths = 2;
        picker.options.numberOfColumns = 2;
      }
    }

    var swipe = {
      onTouchStart: function onTouchStart(evt) {
        var firstTouch = evt.touches[0];
        picker.xTouchDown = firstTouch.clientX;
        picker.yTouchDown = firstTouch.clientY;
      },
      onTouchMove: function onTouchMove(evt) {
        if (!picker.xTouchDown || !picker.yTouchDown) {
          return;
        }

        var xUp = evt.touches[0].clientX;
        var yUp = evt.touches[0].clientY;
        var xDiff = picker.xTouchDown - xUp;
        var yDiff = picker.yTouchDown - yUp;
        var isHorizontal = Math.abs(xDiff) > Math.abs(yDiff);
        var threshold = 100;
        var numberOfMonths = picker.options.numberOfMonths;
        var nextDate = null;
        var canSwipe = false;
        var touchTargetMonth = '';
        var monthItems = Array.from(picker.ui.querySelectorAll('.month-item'));

        if (isHorizontal) {
          var date = picker.DateTime(picker.ui.querySelector('.day-item').dataset.time);
          var opacityValue = Number("".concat(1 - Math.abs(xDiff) / threshold));
          var translateX = 0;

          if (xDiff > 0) {
            translateX = -Math.abs(xDiff);
            nextDate = date.clone().add(numberOfMonths, 'month');
            var maxDate = picker.options.maxDate;
            canSwipe = !maxDate || nextDate.isSameOrBefore(picker.DateTime(maxDate), 'month');
            touchTargetMonth = 'next';
          } else {
            translateX = Math.abs(xDiff);
            nextDate = date.clone().subtract(numberOfMonths, 'month');
            var minDate = picker.options.minDate;
            canSwipe = !minDate || nextDate.isSameOrAfter(picker.DateTime(minDate), 'month');
            touchTargetMonth = 'prev';
          }

          if (canSwipe) {
            monthItems.map(function (x) {
              x.style.opacity = opacityValue;
              x.style.transform = "translateX(".concat(translateX, "px)");
            });
          }
        }

        if (Math.abs(xDiff) + Math.abs(yDiff) > threshold) {
          if (isHorizontal && nextDate && canSwipe) {
            picker.touchTargetMonth = touchTargetMonth;
            picker.gotoDate(nextDate);
          } else {
            if (yDiff > 0) {
              /* up swipe */
            } else {
                /* down swipe */
              }
          }
        }
      },
      onTouchEnd: function onTouchEnd(evt) {
        if (!picker.touchTargetMonth) {
          var monthItems = Array.from(picker.ui.querySelectorAll('.month-item'));
          monthItems.map(function (x) {
            x.style.transform = "translateX(0px)";
            x.style.opacity = 1;
          });
        }
        /* reset values */


        picker.xTouchDown = null;
        picker.yTouchDown = null;
      }
    };
    picker.backdrop = document.createElement('div');
    picker.backdrop.className = 'litepicker-backdrop';
    picker.backdrop.addEventListener('click', picker.hide());

    if (options.element && options.element.parentNode) {
      options.element.parentNode.appendChild(picker.backdrop);
    }

    window.addEventListener('orientationchange', function (evt) {
      // replace to screen.orientation.angle when Safari will support
      // https://caniuse.com/#feat=screen-orientation
      // get correct viewport after changing orientation
      // https://stackoverflow.com/a/49383279/2873909
      var afterOrientationChange = function afterOrientationChange() {
        if (isMobile() && picker.isShowning()) {
          var orientation = getOrientation();

          switch (orientation) {
            case 'landscape':
              options.numberOfMonths = 2;
              options.numberOfColumns = 2;
              break;
            // portrait

            default:
              options.numberOfMonths = 1;
              options.numberOfColumns = 1;
              break;
          }

          picker.ui.classList.toggle('mobilefriendly-portrait', orientation === 'portrait');
          picker.ui.classList.toggle('mobilefriendly-landscape', orientation === 'landscape');
          picker.render();
        }

        window.removeEventListener('resize', afterOrientationChange);
      };

      window.addEventListener('resize', afterOrientationChange);
    });

    if (options.inlineMode && isMobile()) {
      // force trigger orientationchange
      window.dispatchEvent(new Event('orientationchange'));
      window.dispatchEvent(new Event('resize'));
    }

    picker.on('before:show', function (el) {
      picker.triggerElement = el;

      if (!picker.options.inlineMode && isMobile()) {
        picker.emit('mobilefriendly.before:show', el);
        picker.ui.style.position = 'fixed';
        picker.ui.style.display = 'block';
        fitNumberOfMonths();
        picker.scrollToDate(el);
        picker.render();
        var orientation = getOrientation();
        picker.ui.classList.add('mobilefriendly');
        picker.ui.classList.toggle('mobilefriendly-portrait', orientation === 'portrait');
        picker.ui.classList.toggle('mobilefriendly-landscape', orientation === 'landscape');
        picker.ui.style.top = '50%';
        picker.ui.style.left = '50%';
        picker.ui.style.right = null;
        picker.ui.style.bottom = null;
        picker.ui.style.zIndex = picker.options.zIndex;
        picker.backdrop.style.display = 'block';
        picker.backdrop.style.zIndex = picker.options.zIndex - 1;
        document.body.classList.add('litepicker-open');
        (el || picker.options.element).blur();
        picker.emit('mobilefriendly.show', el);
      } else if (isMobile()) {
        fitNumberOfMonths();
        picker.render();
      }
    });
    picker.on('render', function (ui) {
      if (picker.touchTargetMonth) {
        var monthItems = Array.from(picker.ui.querySelectorAll('.month-item'));
        monthItems.map(function (x) {
          return x.classList.add("touch-target-".concat(picker.touchTargetMonth));
        });
      }

      picker.touchTargetMonth = null;
    });
    picker.on('hide', function () {
      document.body.classList.remove('litepicker-open');
      picker.backdrop.style.display = 'none';
      picker.ui.classList.remove('mobilefriendly', 'mobilefriendly-portrait', 'mobilefriendly-landscape');
    });
    picker.on('destroy', function () {
      if (picker.backdrop && picker.backdrop.parentNode) {
        picker.backdrop.parentNode.removeChild(picker.backdrop);
      }
    });
    picker.ui.addEventListener('touchstart', swipe.onTouchStart, supportsPassive ? {
      passive: true
    } : false);
    picker.ui.addEventListener('touchmove', swipe.onTouchMove, supportsPassive ? {
      passive: true
    } : false);
    picker.ui.addEventListener('touchend', swipe.onTouchEnd, supportsPassive ? {
      passive: true
    } : false);
  }
});

/***/ }),

/***/ "./src/plugins/mobilefriendly/style.css":
/*!**********************************************!*\
  !*** ./src/plugins/mobilefriendly/style.css ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var api = __webpack_require__(/*! ../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !../../../node_modules/css-loader/dist/cjs.js!./style.css */ "./node_modules/css-loader/dist/cjs.js!./src/plugins/mobilefriendly/style.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.i, content, '']];
            }

var options = {};

options.insert = function insertAtTop(element) {
                var parent = document.querySelector('head');
                // eslint-disable-next-line no-underscore-dangle
                var lastInsertedElement = window._lastElementInsertedByStyleLoader;

                if (!window.disableLitepickerStyles) {
                  if (!lastInsertedElement) {
                    parent.insertBefore(element, parent.firstChild);
                  } else if (lastInsertedElement.nextSibling) {
                    parent.insertBefore(element, lastInsertedElement.nextSibling);
                  } else {
                    parent.appendChild(element);
                  }

                  // eslint-disable-next-line no-underscore-dangle
                  window._lastElementInsertedByStyleLoader = element;
                }
              };
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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