<?php

add_shortcode('course_dates', 'shortcode_course_dates');

function shortcode_course_dates($attrs) {
    // product defaults to the current post id
    $attrs = shortcode_atts([
        'product' => get_the_ID(),
    ], $attrs);

    $post_id = $attrs['product'];
    // try to get the course associated with this product
    $course = tt_get_course_by_product($post_id);
    if (!$course) {
        return;
    }
    $skip_dates = $course->get_skip_dates();
    $skip_timestamps = array_map(fn($d) => $d->getTimestamp(), $skip_dates);

    // get day of week string
    $dow = $course->get_start_date()->format('l');
    // get all days between start and end
    $dates_between = get_dates_between($course->get_start_date(), $course->get_end_date());

    // filter only this day of week
    $dates_between = array_filter($dates_between, fn($d) => $d->format('l') === $dow);

    // print base string
    $out = $dow . ' ' . $course->get_product()->get_attribute('pa_session') . '<br />';

    // if no dates in between, exit
    if (empty($dates_between)) {
        return;
    }

    // revert array
    $dates_between = array_reverse($dates_between);

    // get the first date
    $d = array_pop($dates_between);

    // skip all leading skipped dates
    while (in_array($d->getTimestamp(), $skip_timestamps)) {
        $d = array_pop($dates_between);
    }

    // get month and day of month strings
    $month_string = $d->format('F');
    $date_string = $d->format('d');

    // print base string
    $out .= '<span style="font-weight: 400;">' . $month_string . ' ' . $date_string;

    // set last month and last day of month
    $last_month = $month_string;
    $last_date = $date_string;

    // continue until array is empty;
    while(($d = array_pop($dates_between)) !== null) {
        // skip all leading skipped dates
        if (in_array($d->getTimestamp(), $skip_timestamps)) {
            continue;
        }

        // repeat routine
        $month_string = $d->format('F');
        $date_string = $d->format('j');
        if ($last_month === $month_string) {
            $out .= ', ' . $date_string;
        } else {
            // print new month name and date
            $out .= '</span> <span style="font-weight: 400;">' . $month_string . ' ' . $date_string;
        }
        $last_month = $month_string;
        $last_date = $date_string;
    }

    // close span
    $out .= '</span>';
    return $out;
}

/**
 * Get array of all dates between date0 and date1.
 * @param $date0
 * @param $date1
 * @return array
 */
function get_dates_between($date0, $date1) {
    $period = new DatePeriod(
        $date0,
        new DateInterval('P1D'),
        $date1
    );
    $out = iterator_to_array($period);
    array_push($out, $date1);
    return $out;
}