<?php

class Course {

    private WC_Product $product;

    private int $id;
    private DateTime $start_date;
    private DateTime $end_date;
    private array $day_of_week;
    private array $skip_dates;

    private array $data;

    public function __construct($data = [])
    {
        $this->data = $data;

        if (isset($data['product_id']) && !isset($data['product'])) {
            $data['product'] = wc_get_product($data['product_id']);
        }

        $data = wp_parse_args($data, [
            'id' => -1,
            'product' => null,
            'start_date' => new DateTime(),
            'end_date' => new DateTime(),
            'day_of_week' => [],
            'skip_dates' => [],
        ]);

        $this->product = $data['product'];

        $this->id = $data['id'];

        $start_date = $data['start_date'];
        $this->start_date = $start_date instanceof DateTime ? $start_date : (new DateTime())->setTimestamp(strtotime($start_date));
        $end_date = $data['end_date'];
        $this->end_date = $end_date instanceof DateTime ? $end_date : (new DateTime())->setTimestamp(strtotime($end_date));
        $day_of_week = $data['day_of_week'];
        $this->day_of_week = maybe_unserialize($day_of_week);
        $skip_dates = $data['skip_dates'];
        $this->skip_dates = maybe_unserialize($skip_dates);
    }

    public function get_id() {
        return $this->id;
    }

    public function get_raw_data($serialize = true) {
        return [
            'product' => $this->product,
            'start_date' => $serialize ? $this->start_date->format('Y-m-d H:i:s') : $this->start_date,
            'end_date' => $serialize ? $this->end_date->format('Y-m-d H:i:s') : $this->end_date,
            'day_of_week' => $serialize ? serialize($this->day_of_week) : $this->day_of_week,
            'skip_dates' => $serialize ? serialize($this->skip_dates) : $this->skip_dates
        ];
    }

    public function get_product(): WC_Product
    {
        return $this->product;
    }

    public function get_day_of_week(): array
    {
        return $this->day_of_week;
    }

    public function add_day_of_week($day)
    {
        if (!is_string($day)) {
            return;
        }

        $this->day_of_week[] = $day;
        return $this;
    }

    public function set_day_of_week($dow)
    {
        if (is_array($dow)) {
            $this->day_of_week = $dow;
        } elseif(is_string($dow)) {
            $this->day_of_week = [$dow];
        }

        return $this;
    }

    public function get_start_date()
    {
        return $this->start_date;
    }

    public function set_start_date($date)
    {
        $this->start_date = $date;
        return $this;
    }

    public function get_end_date()
    {
        return $this->end_date;
    }

    public function set_end_date($date)
    {
        $this->end_date = $date;
        return $this;
    }

    public function get_skip_dates()
    {
        return $this->skip_dates;
    }

    public function add_skip_date($skip_date)
    {
        $this->skip_dates[] = $skip_date;
        return $this;
    }

    public function set_skip_dates($skip_data)
    {
        if (is_string($skip_data)) {
            $skip_data = maybe_unserialize($skip_data);
            if (is_string($skip_data)) {
                $skip_data = [$skip_data];
            }
        }

        $this->skip_dates = $skip_data;
        return $this;
    }

    public static function get_course($id) {
        return tt_get_course_by_id($id);
    }

}