<?php


add_action('updated_post_meta', 'sync_course_data', 10, 4);

/**
 * Synchronize course data when the 'start' or 'end' metas are updated.
 * @param $meta_id
 * @param $post_id
 * @param $meta_key
 * @param $meta_val
 */
function sync_course_data($meta_id, $post_id, $meta_key, $meta_val) {
    if ('product' !== get_post_type($post_id)) {
        return;
    }

    // only check start and end meta
    if ($meta_key === 'start' || $meta_key === 'end') {
        $course_data = tt_get_course_by_product($post_id);
        if ($course_data
            && $course_data->{'get_' . $meta_key . '_date'}()->format('Y-m-d') !== $meta_val) {
            $course_data->{'set_' . $meta_key . '_date'}((new DateTime())->setTimestamp(strtotime($meta_val)));
            tt_update_course_data($course_data);
        }
    }
}

add_action('woocommerce_update_product', 'dispatch_course_updated', PHP_INT_MAX, 1);
add_action('woocommerce_new_product', 'dispatch_course_updated', PHP_INT_MAX, 1);

/**
 * Dispatch a 'taalthuis_course_updated' action for the course associated with the product 'post_id'.
 * @param $post_id
 */
function dispatch_course_updated($post_id) {
    $course = tt_get_course_by_product($post_id);
    if ($course) {
        do_action('taalthuis_course_updated', $course);
    }
}

add_action('woocommerce_new_product', 'create_course_data_entry', PHP_INT_MAX - 1, 1);

/**
 * Create a new course_data entry from new product.
 * @param $post_id
 */
function save_course_data_entry($post_id) {
    $product = wc_get_product($post_id);
    $start = get_post_meta($post_id, 'start', true);
    $end = get_post_meta($post_id, 'end', true);

    $start_date = new DateTime();
    $end_date = new DateTime();

    $course = new Course([
        'product' => $product,
        'start_date' => empty($start) ? $start_date : $start_date->setTimestamp(strtotime($start)),
        'end_date' => empty($end) ? $end_date : $end_date->setTimestamp(strtotime($end)),
    ]);

    if (isset($_POST['skip_dates'])) {
        $dates = $_POST['skip_dates'];
        $arr = explode(',', $dates);
        $arr = array_map(fn($s) => (new DateTime())->setTimestamp(strtotime($s)));
        $course->set_skip_dates($arr);
    }

    tt_update_course_data($course);
    dd($course);
}

add_action('save_post', 'save_skip_dates');
function save_skip_dates($post_id) {
    if (get_post_type($post_id) !== 'product') {
        return;
    }
    $course = tt_get_course_by_product($post_id);
    if ($course && isset($_POST['skip_dates'])) {
        $dates = $_POST['skip_dates'];
        
        $arr = explode(',', $dates);
        $arr = array_map(fn($s) => (new DateTime())->setTimestamp(strtotime($s)),$arr);
        
        $course->set_skip_dates($arr);
        
        tt_update_course_data($course);
    }
}

/**
 * add shortcode support for the_excerpt
 */
add_filter('the_excerpt', 'do_shortcode');