<?php

/**
 * Get a Course by its ID.
 * @param $id
 * @return Course
 */
function tt_get_course_by_id($id) {
    global $wpdb;
    $table = "{$wpdb->prefix}course_data";
    return new Course($wpdb->get_row("
            SELECT * FROM {$table} WHERE `id` = {$id} 
        ", ARRAY_A)
    );
}

/**
 * Get a Course by its associated product (ID).
 * @param $product WC_Product|int
 * @return Course|false Course  if there exists a record where the product is associated,
 *                      false   if the $product is not a WC_Product or int,
 *                              or if the row could not be found for any reason.
 */
function tt_get_course_by_product($product) {
    if ($product instanceof WC_Product) {
        $product_id = $product->get_id();
    } elseif (is_numeric($product)) {
        $product_id = $product;
    } else {
        return false;
    }

    global $wpdb;
    $table = "{$wpdb->prefix}course_data";
    $query = "SELECT * FROM {$table} 
                WHERE `product_id` = {$product_id}";
    $row = $wpdb->get_row($query, ARRAY_A);
    if ($row) {
        return new Course($row);
    }

    return false;
}

/**
 * Filter method for check if a value is null.
 * @param $value
 * @return bool
 */
function is_not_null($value) {
    return $value !== null;
}

/**
 * Update a Course database record
 * @param $course Course the course to update.
 * @return bool|int the result of $wpdb->update() or $wpdb->insert().
 */
function tt_update_course_data(Course $course) {
    global $wpdb;

    // get serialized data
    $data = $course->get_raw_data();

    // product or product id must be set
    if (!isset($data['product']) && !isset($data['product_id'])) {
        return false;
    }

    // set product_id if not set
    if (isset($data['product']) && !isset($data['product_id'])) {
        $data['product_id'] = $data['product']->get_id();
        unset($data['product']);
    }

    // parse arguments
    $data = wp_parse_args($data, [
        'product_id' => null,
        'start_date' => null,
        'end_date' => null,
        'day_of_week' => null,
        'skip_dates' => null,
    ]);

    // remove null vals
    $data = array_filter($data, 'is_not_null');

    $table = "{$wpdb->prefix}course_data";
    $product_id = $data['product_id'];
    // insert or update
    if (isset($data['id']) || tt_get_course_by_product($product_id)) {
        $result = $wpdb->update($table, $data, ['product_id' => $product_id]);
    } else {
        $result = $wpdb->insert($table, $data);
    }

    return $result;
}


add_filter( 'woocommerce_locate_template', 'woo_adon_plugin_template', 1, 3 );
function woo_adon_plugin_template( $template, $template_name, $template_path ) {
    global $woocommerce;
    $_template = $template;
    if ( ! $template_path )
        $template_path = $woocommerce->template_url;

    $plugin_path  = untrailingslashit( plugin_dir_path( __FILE__ ) )  . '/woocommerce/';

    // Look within passed path within the theme - this is priority
    $template = locate_template(
        array(
            $template_path . $template_name,
            $template_name
        )
    );

    if( ! $template && file_exists( $plugin_path . $template_name ) )
        $template = $plugin_path . $template_name;

    if ( ! $template )
        $template = $_template;

    return $template;
}