const monthNames = ["January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"];
const dayNames = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']

/**
 * Get all indices of val in arr.
 * @param arr
 * @param val
 * @return {number[]} list of integers
 */
function getAllIndices(arr, val) {
    var indices = [], i;
    for(i = 0; i < arr.length; i++)
        if (arr[i] === val)
            indices.push(i);
    return indices;
}

/**
 * Add days to a Date instance
 * @param {Date} date
 * @param {number} days
 * @return {Date}
 */
function addDays(date, days) {
    var date = new Date(date);
    date.setDate(date.getDate() + days);
    return date;
}

/**
 * Get all dates in between the startDate and stopDate
 * @param {Date} startDate
 * @param {Date} stopDate
 * @return {Date[]}
 */
function getDates(startDate, stopDate) {
    var dateArray = new Array();
    var currentDate = startDate;
    while (currentDate <= stopDate) {
        dateArray.push(new Date(currentDate));
        currentDate = addDays(currentDate, 1);
    }
    return dateArray;
}

function tryOrNone(fn) {
    try {
        fn();
    } catch (e) {
        console.debug('Function could not be executed: ', fn.toString());
    }
}

/**
 * Get all dates in between date0 and date1, matching the dayOfWeek number.
 * @param {Date} date0
 * @param {Date} date1
 * @param {number} dayOfWeek
 * @return {Date[]}
 */
function getDatesBetween(date0, date1, dayOfWeek) {
    if (typeof(dayOfWeek) === 'string') {
        dayOfWeek = dayNames[dayOfWeek];
    }

    let dates = getDates(date0, date1);
    return dates.filter(d => d.getDay() === dayOfWeek);
}

let delimiter = ' - ';
const mainPicker = new Litepicker({
    element: document.getElementById('course-start'),
    elementEnd: document.getElementById('course-end'),
    parentEl: document.getElementById('litepicker-container'),
    inlineMode: true,
    singleMode: false,
    numberOfColumns: 2,
    numberOfMonths: 2,
    startDate: initialDates.start,
    endDate: initialDates.end,
    delimiter: delimiter,
    setup: (picker) => {
        picker.on('selected', (start, end) => {
            let dow = dayNames[start.dateInstance.getDay()];
            document.getElementById('course-dow').setAttribute('value', dow);

            let sDate = start.dateInstance;
            let eDate = end.dateInstance;

            tryOrNone(() => {
                let month = ''+ (sDate.getMonth() + 1);
                month = month.length === 1 ? '0' + month : month;
                let date = '' + sDate.getDate();
                date = date.length === 1 ? '0' + date : date;
                return document
                    .querySelector('input[class="rwmb-date hasDatepicker"][name="start"]')
                    .setAttribute('value', (sDate.getYear() + 1900) + '-' + month + '-' + date);
            });
            tryOrNone(() => {
                let month = ''+ (eDate.getMonth() + 1);
                month = month.length === 1 ? '0' + month : month;
                let date = '' + eDate.getDate();
                date = date.length === 1 ? '0' + date : date;
                document
                    .querySelector('input[class="rwmb-date hasDatepicker"][name="end"]')
                    .setAttribute('value', (eDate.getYear() + 1900) + '-' + month + '-' + date)
            });

            renderPreview();
        });
        picker.on('render', (ui) => {
            if (picker.getStartDate()) {
                let dow = dayNames[picker.getStartDate().dateInstance.getDay()];
                document.getElementById('course-dow').setAttribute('value', dow);
            }
        })
    }
});

const skipsPicker = new Litepicker({
    element: document.getElementById('course-skipdates'),
    plugins: ['multiselect'],
    autoApply: true,
    autoRefresh: true,
    delimiter: delimiter,
    setup: (picker) => {
        picker.on('show', () => {
            picker.gotoDate(mainPicker.getStartDate());
        });
        picker.on('button:apply', () => {
            skipsPicker.options.element.value = skipsPicker.multipleDatesToString();
        })
        picker.on('multiselect.select', (cell) => {
            let date = cell.dateInstance;
            let currentSkips = mainPicker.options.highlightedDays;

            if (mainPicker.getStartDate().getTime() > date.getTime()
                || mainPicker.getEndDate().getTime() < date.getTime()) {
                picker.preMultipleDates.splice(picker.preMultipleDates.indexOf(date.getTime()), 1);
                picker.emit('multiselect.deselect', cell);
            } else {
                if (!currentSkips.includes(date)) {
                    currentSkips.push(date);
                }
                mainPicker.setHighlightedDays(currentSkips);
            }

            renderPreview();
        });
        picker.on('multiselect.deselect', (cell) => {
            let date = cell.dateInstance;
            let currentSkips = mainPicker.options.highlightedDays;
            let dateIndices = getAllIndices(currentSkips.map(d => d.format('YYYY-MM-DD')), cell.format('YYYY-MM-DD'));
            currentSkips = currentSkips.map((d, idx) => dateIndices.includes(idx) ? null : d).filter(d => d);
            mainPicker.setHighlightedDays(currentSkips);

            renderPreview();
        });
    }
});

// if initialDates is set, simulate a date selection in skipsPicker
if (initialDates) {
    // iterate over each skip date
    initialDates.skip.forEach(d => {
        let sd = document.getElementById('course-skipdates');
        let val = sd.value;
        if (val.length !== 0) {
            sd.value += ',' + d;
        } else {
            sd.value = d;
        }

        let date = skipsPicker.DateTime(new Date(d), 'YYYY-MM-DD');
        skipsPicker.preMultipleDates[skipsPicker.preMultipleDates.length] = date.timestamp();

        skipsPicker.emit('multiselect.select', date);

        skipsPicker.emit('render:day', document.querySelector('div[data-time="' + date.timestamp() + '"]'));
    });

    skipsPicker.emit('button.apply');
    skipsPicker.render();
}

/**
 * Render preview text with the current values.
 */
function renderPreview() {
    // set dow
    document.getElementById('preview_day_of_week').innerHTML = dayNames[mainPicker.getStartDate().getDay()];

    // get dates between start and end
    let dates = getDatesBetween(mainPicker.getStartDate().dateInstance, mainPicker.getEndDate().dateInstance, mainPicker.getStartDate().dateInstance.getDay());
    let skipDates = skipsPicker.preMultipleDates;

    if (dates.length === 0) {
        return;
    }

    dates = dates.reverse();
    let currentDate = dates.pop();
    let currentMonth = currentDate.getMonth();
    let el = document.getElementById('preview_dates');

    while (skipDates.includes(currentDate.getTime()) && dates.length !== 0) {
        currentDate = dates.pop();
    }

    let content = '<div><span style="font-weight: 400;">' + monthNames[currentDate.getMonth()] + ' ' + currentDate.getDate();
    let lastDate = currentDate;
    let lastMonth = currentMonth;
    while (dates.length !== 0) {
        currentDate = dates.pop();
        if (skipDates.includes(currentDate.getTime())) {
            continue;
        }
        currentMonth = currentDate.getMonth();
        if (currentMonth === lastMonth) {
            content += ', ' + currentDate.getDate();
        } else {
            content += '</span> <span style="font-weight:400;">' + monthNames[currentDate.getMonth()] + ' ' + currentDate.getDate();
        }
        lastDate = currentDate;
        lastMonth = currentMonth;
    }

    el.innerHTML = content + '</div>';

}

/* Notify user checkbox + value listeners */

var notifyCb = document.getElementById('course-notify-users');
var notify = {
    start: false,
    end: false,
    skips: false
};

/**
 * Set the disable attribute when any value in `notify` is true
 */
function enableNotifyCheckbox() {
    if (notify.start || notify.end || notify.skips) {
        document.getElementById('course-notify-users').removeAttribute('disabled');
    } else {
        document.getElementById('course-notify-users').setAttribute('disabled', 'disabled');
    }
}

// add listeners for the value attribute of each input
[[document.getElementById('course-start'), 'start'],
    [document.getElementById('course-end'), 'end'],
    [document.getElementById('course-skipdates'), 'skips']].forEach(([e, prop]) => {
        const descriptor = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(e), 'value');
        Object.defineProperty(e, 'value', {
            set: function(t) {
                let res = descriptor.set.apply(this, arguments);
                notify[prop] = initialDates[prop] !== t;
                enableNotifyCheckbox();
                return res;
            },
            get: function() {
                return descriptor.get.apply(this);
            }
        });
});
enableNotifyCheckbox();

renderPreview();