<?php

namespace WordpressModelsTests\Model;

use WordpressModels\DataModels\Attribute\AsJson;
use WordpressModels\DataModels\Attribute\DateTimeFormat;
use WordpressModels\DataModels\Model;

class HydratableModel extends Model
{

    private int $intProperty;

    private string $stringProperty;

    private float $floatProperty;

    private object $objectProperty;

    private array $arraySerializeProperty;

    #[AsJson]
    private array $jsonFormatProperty;

    private \DateTimeInterface $dateTimeInterfaceProperty;

    #[DateTimeFormat('timestamp')]
    private \DateTime $dateTimeTimestampProperty;

    #[DateTimeFormat(\DateTimeInterface::ATOM)]
    private \DateTime $dateTimeAtomFormatProperty;

    #[DateTimeFormat('d/m/Y')]
    private \DateTime $dateTimeCustomFormatProperty;

    public function getIntProperty(): int
    {
        return $this->intProperty;
    }

    public function setIntProperty(int $intProperty): HydratableModel
    {
        $this->intProperty = $intProperty;
        return $this;
    }

    public function getStringProperty(): string
    {
        return $this->stringProperty;
    }

    public function setStringProperty(string $stringProperty): HydratableModel
    {
        $this->stringProperty = $stringProperty;
        return $this;
    }

    public function getFloatProperty(): float
    {
        return $this->floatProperty;
    }

    public function setFloatProperty(float $floatProperty): HydratableModel
    {
        $this->floatProperty = $floatProperty;
        return $this;
    }

    public function getObjectProperty(): object
    {
        return $this->objectProperty;
    }

    public function setObjectProperty(object $objectProperty): HydratableModel
    {
        $this->objectProperty = $objectProperty;
        return $this;
    }

    public function getArraySerializeProperty(): array
    {
        return $this->arraySerializeProperty;
    }

    public function setArraySerializeProperty(array $arraySerializeProperty): HydratableModel
    {
        $this->arraySerializeProperty = $arraySerializeProperty;
        return $this;
    }

    public function getJsonFormatProperty(): array
    {
        return $this->jsonFormatProperty;
    }

    public function setJsonFormatProperty(array $jsonFormatProperty): HydratableModel
    {
        $this->jsonFormatProperty = $jsonFormatProperty;
        return $this;
    }

    public function getDateTimeInterfaceProperty(): \DateTimeInterface
    {
        return $this->dateTimeInterfaceProperty;
    }

    public function setDateTimeInterfaceProperty(\DateTimeInterface $dateTimeInterfaceProperty): HydratableModel
    {
        $this->dateTimeInterfaceProperty = $dateTimeInterfaceProperty;
        return $this;
    }

    public function getDateTimeTimestampProperty(): \DateTime
    {
        return $this->dateTimeTimestampProperty;
    }

    public function setDateTimeTimestampProperty(\DateTime $dateTimeTimestampProperty): HydratableModel
    {
        $this->dateTimeTimestampProperty = $dateTimeTimestampProperty;
        return $this;
    }

    public function getDateTimeAtomFormatProperty(): \DateTime
    {
        return $this->dateTimeAtomFormatProperty;
    }

    public function setDateTimeAtomFormatProperty(\DateTime $dateTimeAtomFormatProperty): HydratableModel
    {
        $this->dateTimeAtomFormatProperty = $dateTimeAtomFormatProperty;
        return $this;
    }

    public function getDateTimeCustomFormatProperty(): \DateTime
    {
        return $this->dateTimeCustomFormatProperty;
    }

    public function setDateTimeCustomFormatProperty(\DateTime $dateTimeCustomFormatProperty): HydratableModel
    {
        $this->dateTimeCustomFormatProperty = $dateTimeCustomFormatProperty;
        return $this;
    }

}