<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM;

use WordpressModels\ORM\WooCommerceEntity\PostType\Product;
use WordpressModels\ORM\WooCommerceEntity\PostType\ShopOrder;
use WordpressModels\Traits\SingletonTrait;

class WooCommerceEntities
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('doctrine_entity_directories', $this->addEntityDirectories(...));
        add_filter('doctrine_post_type_discriminator_map', $this->addPostTypeDiscriminators(...));
    }

    public function addEntityDirectories(array $directories): array
    {
        return [...$directories, __DIR__ . '/WooCommerceEntity/PostType'];
    }

    public function addPostTypeDiscriminators(array $classMap): array
    {
        return $classMap + [
                'product' => Product::class,
                'shop_order' => ShopOrder::class
            ];
    }

}
