<?php

namespace RtmBusiness\PostSync\Action;

use DateTime;
use RtmBusiness\PostSync\Logger;
use RtmBusiness\PostSync\SyncController;

/**
 * This action is triggered on trashing a post (soft delete)
 */
class TrashAction implements SyncAction
{

    /**
     * @inheritDoc
     */
    public function execute(int $postId)
    {
        if (!current_user_can("postsync_can_trashrestore")) {
            Logger::warning("Trash", "User doesn't have permission to trash on this blog", "TrashAction", "sync", ['fromBlog' => get_current_blog_id()]);
            return;
        }

        //Soft delete this post in sync data
        SyncController::instance()->updateChildDeletedOn(get_current_blog_id(), $postId, new DateTime());
    }
}