<?php

namespace WordpressModelsTests\Model;

use WordpressModels\DataModels\Attribute\DateTimeFormat;
use WordpressModels\DataModels\Model;

/**
 * A Datamodel containing an invalid DateTime formatted property
 */
class InvalidDateTimeModel extends Model
{

    #[DateTimeFormat('q')]
    private \DateTime $invalidDateTimeFormat;

    public function getInvalidDateTimeFormat(): \DateTime
    {
        return $this->invalidDateTimeFormat;
    }

    public function setInvalidDateTimeFormat(\DateTime $invalidDateTimeFormat): self
    {
        $this->invalidDateTimeFormat = $invalidDateTimeFormat;
        return $this;
    }

}