<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpUsermeta
 */
#[ORM\Table('usermeta')]
#[ORM\Index(['meta_key'], name: 'meta_key')]
#[ORM\Entity]
class UserMeta
{
    #[ORM\Column(name: 'umeta_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[
        ORM\ManyToOne(targetEntity: User::class, inversedBy: 'meta'),
        ORM\JoinColumn('user_id', referencedColumnName: 'ID')
    ]
    #[MaxDepth(1)]
    private User $user;

    #[ORM\Column(name: 'meta_key', type: Types::STRING, length: 255, nullable: true)]
    private ?string $key = null;

    #[ORM\Column(name: 'meta_value', type: Types::TEXT, length: 0, nullable: true)]
    private ?string $value = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): UserMeta
    {
        $this->id = $id;
        return $this;
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function setUser(User $user): UserMeta
    {
        $this->user = $user;
        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(?string $key): UserMeta
    {
        $this->key = $key;
        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): UserMeta
    {
        $this->value = $value;
        return $this;
    }

}
