<?php

namespace RtmBusiness\PostSync;

use Exception;
use RtmBusiness\PostSync\Migrations\InitLoggerMigration;

class Logger
{
    const CHANNEL = 'POSTSYNC-LOGGER';

    /**
     * Adds new log item to wonolog
     * @param int $severity severity level based on monolog
     * @param string $title title of the log
     * @param string $message message of the log
     * @param string $source source where the log is from
     * @param string $category category of the log
     * @param array $data given data for log
     * @return void
     * @throws Exception
     */
    private static function log(int $severity, string $title, string $message, string $source, string $category, array $data): void
    {
        $migration = new InitLoggerMigration();
        if (!$migration->isMigrated()) {
            $migration->migrate();
        }

        do_action('wonolog.log', [
            'message' => $message,
            'channel' => self::CHANNEL,
            'level' => $severity,
            'context' => [
                'title' => $title,
                'category' => $category,
                'source' => $source,
                'metadata' => self::getMetadata(),
                'data' => $data
            ],
        ]);
    }

    /**
     * @param string $title title of the log
     * @param string $message message of the log
     * @param string $source source where the log is from
     * @param string $category category of the log
     * @param array $data given data for log
     * @return void
     */
    public static function error(string $title, string $message, string $source, string $category = 'plugin', array $data = []): void
    {
        self::log(\Monolog\Logger::ERROR, $title, $message, $source, $category, $data);
    }

    /**
     * @param string $title title of the log
     * @param string $message message of the log
     * @param string $source source where the log is from
     * @param string $category category of the log
     * @param array $data given data for log
     * @return void
     */
    public static function warning(string $title, string $message, string $source, string $category = 'plugin', array $data = []): void
    {
        self::log(\Monolog\Logger::WARNING, $title, $message, $source, $category, $data);
    }

    /**
     * @param string $title title of the log
     * @param string $message message of the log
     * @param string $source source where the log is from
     * @param string $category category of the log
     * @param array $data given data for log
     * @return void
     */
    public static function info(string $title, string $message, string $source, string $category = 'plugin', array $data = []): void
    {
        self::log(\Monolog\Logger::INFO, $title, $message, $source, $category, $data);
    }

    /**
     * @param string $title title of the log
     * @param string $message message of the log
     * @param string $source source where the log is from
     * @param string $category category of the log
     * @param array $data given data for log
     * @return void
     */
    public static function debug(string $title, string $message, string $source, string $category = 'plugin', array $data = []): void
    {
        self::log(\Monolog\Logger::DEBUG, $title, $message, $source, $category, $data);
    }

    /**
     * Gets the metadata that contains WordPress information
     * @return array
     */
    private static function getMetadata(): array
    {
        // TODO: Generate metadata (as much data as possible, such as WP data or Plugin data)
        return [$_POST];
    }
}
