<?php

namespace RtmBusiness\PostSync\Migrations;

interface MigrationInterface
{
    /**
     * Execute the class SQL code for migration
     * @return void
     */
    public function migrate(): void;

    /**
     * Rolls back the executed SQL for migration
     * @return void
     */
    public function rollback(): void;

    /**
     * Checks if the migration class is migrated already
     * @return bool
     */
    public function isMigrated(): bool;

    /**
     * Gets the priority level of migration class
     * @return int priority level
     */
    public function getPriority(): int;
}
