<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpPostmeta
 */
#[ORM\Table('postmeta')]
#[ORM\Index(['meta_key'], name: 'meta_key')]
#[ORM\Entity]
class PostMeta
{
    #[ORM\Column(name: 'meta_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\ManyToOne(targetEntity: Post::class, inversedBy: 'meta'), ORM\JoinColumn('post_id', referencedColumnName: 'ID')]
    #[MaxDepth(1)]
    private Post $post;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'meta_key', type: Types::STRING, length: 255, nullable: true)]
    private ?string $key = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'meta_value', type: Types::TEXT, length: 0, nullable: true)]
    private ?string $value = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): PostMeta
    {
        $this->id = $id;
        return $this;
    }

    public function getPost(): Post
    {
        return $this->post;
    }

    public function setPost(Post $post): PostMeta
    {
        $this->post = $post;
        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(?string $key): PostMeta
    {
        $this->key = $key;
        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): PostMeta
    {
        $this->value = $value;
        return $this;
    }

}
