<?php

namespace RtmBusiness\PostSync\Pages;

use WordpressModels\Assets;
use WordpressModels\Page;

class SettingsPage extends Page
{

    /**
     * @param Assets $assets
     */
    public function __construct(Assets $assets)
    {
        parent::__construct('settings', 'postsync-settings', 'PostSync Settings', 'toplevel', 'administrator', null, '', [], $assets);
    }

    /**
     * @inheritDoc
     */
    public function buildContext(array $context = []): mixed
    {
        $sync_metadata = get_site_option('postsync_sync_metadata', false) == 1;
        $sync_taxonomies = get_site_option('postsync_sync_taxonomies', false) == 1;
        $context['sync_metadata'] = $sync_metadata;
        $context['sync_taxonomies'] = $sync_taxonomies;
        $context['post_types'] = get_post_types();
        $context['enabled_post_types'] = get_site_option('postsync_enabled_post_types');

        return $context;
    }

    /**
     * @inheritDoc
     */
    public function doEnqueue()
    {
        wp_localize_script('settings', 'WP_REST', [
            'url' => get_rest_url(),
            'nonce' => wp_create_nonce('wp_rest'),
            'debug' => wp_get_environment_type() === 'development'
        ]);

    }
}