<?php

namespace RtmBusiness\PostSync\Model;

use DateTime;
use JsonSerializable;

class SyncableChild implements JsonSerializable
{

    /**
     * @var bool Whether the posts with duplicate slug should be overwritten
     */
    public bool $overwriteSlug = false;

    /**
     * @var DateTime|null
     */
    public ?DateTime $deletedOn;

    /**
     * @param int $blogId The child blog id
     * @param int $postId The post id on the child site
     */
    public function __construct(public int $blogId, public int $postId)
    {
        $this->deletedOn = null;
    }

    /**
     * @return bool
     */
    public function isOverwriteSlug(): bool
    {
        return $this->overwriteSlug;
    }

    /**
     * @param bool $overwriteSlug
     */
    public function setOverwriteSlug(bool $overwriteSlug): void
    {
        $this->overwriteSlug = $overwriteSlug;
    }

    /**
     * @param DateTime|null $deletedOn
     */
    public function setDeletedOn(?DateTime $deletedOn): void
    {
        $this->deletedOn = $deletedOn;
    }


    /**
     * @return DateTime|null The datetime when this SyncableChild post was softdeleted
     */
    public function getDeletedOn(): ?DateTime
    {
        return $this->deletedOn;
    }

    /**
     * How this object should be serialized in the JSON
     *
     * @return array
     */
    public function jsonSerialize(): array
    {
        return [
            'blogId' => $this->blogId,
            'postId' => $this->postId,
            'deletedOn' => $this->deletedOn?->format(DATE_ATOM),
            'overwriteSlug' => $this->overwriteSlug,
        ];
    }

}