<?php

namespace RtmBusiness\PostSync\Model;

use DateTime;
use DateTimeInterface;

class Log extends BaseModel
{
    /**
     * @column id
     * @column-type int(11)
     * @primary
     * @var int
     */
    protected int $id;
    /**
     * @column title
     * @column-type varchar(255)
     * @var string
     */
    protected string $title;
    /**
     * @column message
     * @column-type text
     * @var string
     */
    protected string $message;
    /**
     * @column severity
     * @column-type enum('error', 'info', 'warning', 'debug')
     * @var string
     */
    protected string $severity;
    /**
     * @column source
     * @column-type varchar(255)
     * @var string
     */
    protected string $source;
    /**
     * @column category
     * @column-type varchar(255)
     * @var string
     */
    protected string $category;
    /**
     * @column data
     * @column-type json
     * @var array
     */
    protected array $data;
    /**
     * @column metadata
     * @column-type json
     * @var array
     */
    protected array $metadata;
    /**
     * @column timestamp
     * @column-type datetime
     * @var DateTime
     */
    protected DateTime $timestamp;

    public function __construct(array $properties = [])
    {
        parent::__construct($properties);
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @param string $message
     */
    public function setMessage(string $message): void
    {
        $this->message = $message;
    }

    /**
     * @return string
     */
    public function getSeverity(): string
    {
        return $this->severity;
    }

    /**
     * @param string $severity
     */
    public function setSeverity(string $severity): void
    {
        $this->severity = strtolower($severity);
    }

    /**
     * @return string
     */
    public function getSource(): string
    {
        return $this->source;
    }

    /**
     * @param string $source
     */
    public function setSource(string $source): void
    {
        $this->source = $source;
    }

    /**
     * @return string
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * @param string $category
     */
    public function setCategory(string $category): void
    {
        $this->category = $category;
    }

    /**
     * @return array|false|string
     */
    public function getData($json = false): bool|array|string
    {
        return $json ? json_encode($this->data, JSON_HEX_APOS) : $this->data;
    }

    /**
     * @param array $data
     */
    public function setData(array $data): void
    {
        $this->data = $data;
    }

    /**
     * @return array|false|string
     */
    public function getMetadata($json = false): bool|array|string
    {
        return $json ? json_encode($this->metadata, JSON_HEX_APOS) : $this->metadata;
    }

    /**
     * @param array $metadata
     */
    public function setMetadata(array $metadata): void
    {
        $this->metadata = $metadata;
    }

    /**
     * @return DateTime
     */
    public function getTimestamp(): DateTime
    {
        return $this->timestamp;
    }

    public function getTimestampISO(): string
    {
        $dt = $this->timestamp->format(DateTimeInterface::ATOM);
        return str_replace("+00:00", ".000Z", $dt);
    }

    /**
     * @param DateTime $timestamp
     */
    public function setTimestamp(DateTime $timestamp): void
    {
        $this->timestamp = $timestamp;
    }

    public function format(): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'message' => $this->message,
            'severity' => $this->severity,
            'source' => $this->source,
            'category' => $this->category,
            'data' => $this->data,
            'metadata' => $this->metadata,
            'timestamp' => $this->timestamp,
        ];
    }

    public static function getSearchFields(): array
    {
        return [
            'title',
            'message',
            'source',
            'data',
            'metadata'
        ];
    }

    public static function getTable(): string
    {
        global $wpdb;
        return $wpdb->base_prefix . 'rtm_sync_logs';
    }

    public static function getPrimaryKey(): string
    {
        return 'id';
    }
}
