<?php

namespace RtmBusiness\PostSync;

use Monolog\Handler\AbstractProcessingHandler;
use RtmBusiness\PostSync\Model\Log;

class LogHandler extends AbstractProcessingHandler
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @inheritDoc
     */
    protected function write(array $record): void
    {
        if (Logger::CHANNEL != $record['channel']) {
            return;
        }

        $log = new Log();
        $log->setTitle($record['context']['title']);
        $log->setMessage($record['message']);
        $log->setSeverity($record['level_name']);
        $log->setSource($record['context']['source']);
        $log->setCategory($record['context']['category']);
        $log->setData($record['context']['data']);
        $log->setMetadata($record['context']['metadata']);
        $log->setTimestamp($record['datetime']);

        $log->save();
    }
}
