<?php

namespace RtmBusiness\PostSync\Action;

use RtmBusiness\PostSync\Logger;
use RtmBusiness\PostSync\SyncController;

/**
 * This action is triggered on recovering a post from the trash
 */
class RecoverAction implements SyncAction
{

    /**
     * @inheritDoc
     */
    public function execute(int $postId)
    {
        if (!current_user_can("postsync_can_trashrestore")) {
            Logger::warning("Recover", "User doesn't have permission to recover on this blog", "RecoverAction", "sync", ['fromBlog' => get_current_blog_id()]);
            return;
        }

        //Undo soft delete for this post in sync data
        SyncController::instance()->updateChildDeletedOn(get_current_blog_id(), $postId, null);
    }
}