<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpCommentmeta
 */
#[ORM\Table('commentmeta')]
#[ORM\Index(['meta_key'], name: 'meta_key')]
#[ORM\Entity]
class CommentMeta
{

    #[ORM\Column(name: 'meta_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[
        ORM\ManyToOne(targetEntity: Comment::class, inversedBy: 'meta'),
        ORM\JoinColumn('comment_id', referencedColumnName: 'comment_ID')
    ]
    #[MaxDepth(1)]
    private Comment $comment;

    #[ORM\Column(name: 'meta_key', type: Types::STRING, length: 255, nullable: true)]
    private ?string $key = null;

    #[ORM\Column(name: 'meta_value', type: Types::TEXT, length: 0, nullable: true)]
    private ?string $value = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getComment(): Comment
    {
        return $this->comment;
    }

    public function setComment(Comment $comment): CommentMeta
    {
        $this->comment = $comment;
        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(?string $key): CommentMeta
    {
        $this->key = $key;
        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): CommentMeta
    {
        $this->value = $value;
        return $this;
    }


}
