<?php

namespace RtmBusiness\PostSync\SyncHandlers;

abstract class AbstractSyncHandler
{

    /**
     * Executes additional syncing actions inside the target blog context, after the base syncing has finished
     * @param int $sourceBlogId The blog id for the source post
     * @param int $sourcePostId The post id for the source post
     * @param int $targetBlogId The blog id for the target post
     * @param int $targetPostId The post id for the target post
     * @return void
     */
    abstract public function handle(int $sourceBlogId, int $sourcePostId, int $targetBlogId, int $targetPostId): void;
}
