<?php
global $ms_eventman_options;
$options = $ms_eventman_options;

?>
<div class="wrap">
    <h1>
        <?=__("Multisite Event manager options", 'ms-eventman')?>
    </h1>
    <form method="post" action="admin.php?page=ms-eventman-options" name="ms_eventman_options" id="ms_eventman_options">
        <h2>
            <?= __("General","ms-eventman") ?>
        </h2>
        <?= wp_nonce_field('save-ms-eventman-options'); ?>
        <input type="hidden" name="ms_eventman_options[placeholder]" id="ms_eventman_options_placeholder" value="1" />
        <table class="form-table table-striped">
            <tbody>
                <tr>
                    <th scope="col">
                        <label for="ms_eventman_options_enable_debug">
                            <?= __('Enable debug logging', 'ms-eventman') ?>
                        </label>
                    </th>
                    <td>
                        <input type="checkbox" name="ms_eventman_options[enable_debug]" id="ms_eventman_options_enable_debug" <?= isset($options['enable_debug']) && $options['enable_debug'] == 'on' ? 'checked="checked"' : ''?> />
                    </td>
                </tr>
                <tr>
                    <th scope="col">
                        <?= __("Hook Logging (Comma separated)", 'ms-eventman') ?>
                    </th>
                    <th>
                        <textarea name="ms_eventman_options[debug_hooks]" id="ms_eventman_options_enable_debug"><?= join(', ', $ms_eventman_options['debug_hooks'] ?? []) ?></textarea>
                    </th>
                </tr>
            </tbody>
        </table>
        <button type="submit" class="button button-primary"><?= __('Save Changes') ?></button>
    </form>
</div>
