<?php

namespace Eventman\Includes\Views;

use plainview\sdk_broadcast\wordpress\tabs\tabs;
use threewp_broadcast\api\api;
use WP_Post;

class CustomPostTypeViewBuilder
{
    /**
     * @param $postType string a valid post type
     * @return string the broadcast table as a page.
     */
    public static function broadcastTablePage($postType)
    {
        $title = __(ucfirst($postType));

        $currentBlogId = get_current_blog_id();
        switch_to_blog(get_main_site_id());
        $out = sprintf('<div class="wrap"><h1 id="edit-site">%s</h1>', 'Broadcast ' . __($title) . ' from ' . get_bloginfo('name'));
        switch_to_blog($currentBlogId);

        // navigation tabs
        ob_start();
        $out .= ob_get_clean();

        $table = new BroadcastListTable($postType);
        $table->prepare_items();
        $table->views();

        // print search
        $out .= '<form method="post"><input type="hidden" name="page" value="broadcast_search">';
        ob_start();
        $table->search_box( __('Search', 'ms-eventman'), 'search_id' );
        $out .= ob_get_clean();
        $out .= '</form>';

        $out .= '<form method="post" id="broadcast-apply"><input type="hidden" name="page" value="broadcast_apply">';

        ob_start();
        $table->display();
        $out .= ob_get_clean() . '</div>';
        $out .= '</form>';


        return $out;
    }

}