<?php


namespace Eventman\Admin;


class Dashboard
{

    /**
     * Dashboard constructor.
     */
    public function __construct()
    {
    }

    /**
     * Generate the 'Events' info box on the dashboard.
     */
    public function guideEvents() {
        echo '<div><p>' . __("The '<i class=\"dashicons dashicons-schedule\"></i> Events' menu shows a form and a list of previous events. To create a new event, just fill in the year of the event in the 'Name' field and the description, the 'slug' will be filled in automatically with the event name. ", 'ms-eventman') . '</p>' .
                '<p>' .__("When you click an event, a more detailed form is shown, where you can fill in further information about the event, like prices, location, ticket URL. When you're ready to publish the event, check the 'Publish' box in the form and save the settings.", 'ms-eventman') . '</p>'
            . '</div>';
    }

    /**
     * Generate the 'Exhibitors' info box on the dashboard.
     */
    public function guideExhibitors() {
        $siteSpecificText = is_main_site()
            ? __('Here in the main site you can add new exhibitors and distribute them in the edit panel. You can add an image gallery to the exhibitor, which will be distributed to the selected sites as well. <strong>The data in the main site will overwrite any data in a specific site.</strong>')
            : __("In subsites you can select the 'Broadcasts' menu item under 'Exhibitors'. The page shows a list of all exhibitors contained in the <strong>main site</strong>. You can select exhibitors to broadcast to this site as well as unlink, trash and delete the broadcasted exhibitors.", "ms-eventman");
        echo '<div>' . __("<p>The '<i class=\"dashicons dashicons-visibility\"></i> Exhibitors' menu shows a list of available exhibitors. You can edit exhibitors by clicking on them.</p>", 'ms-eventman')
            . "<p>$siteSpecificText</p>"
            . '<p>' . __('') . '</p></div>';
    }

    /**
     * Generate the 'Partners' info box on the dashboard.
     */
    public function guidePartners() {
        $siteSpecificText = is_main_site()
            ? __('Here in the main site you can add new partners and distribute them in the edit panel. You can add an image gallery to the partner, which will be distributed to the selected sites as well. <strong>The data in the main site will overwrite any data in a specific site.</strong>')
            : __("In subsites you can select the 'Broadcasts' menu item under '<i class=\"dashicons dashicons-admin-users\"></i>Partners'. The page shows a list of all partners contained in the <strong>main site</strong>. You can select partners to broadcast to this site as well as unlink, trash and delete the broadcasted partners.", "ms-eventman");
        echo '<div>' . __("<p>The '<i class=\"dashicons dashicons-admin-users\"></i> Partners' menu shows a list of available partners. You can edit partners by clicking on them.</p>", 'ms-eventman')
            . "<p>$siteSpecificText</p>"
            . '<p>' . __('') . '</p></div>';
    }

    /**
     * Generate the 'News' info box on the dashboard.
     */
    public function guideNews() {
        echo '<div><p>' . __('News posts works the same as on any Wordpress site, more information on that ', 'ms-eventman')
            . '<a href="https://wordpress.org/support/article/writing-posts/">'
            . __('here', 'ms-eventman')
            .'</a>.</p>'
            . __('Posts and pages can be broadcasted to subsites as well, they behave the same as Exhibitors and Partners, any data add on ', 'ms-eventman')
            .( is_main_query() ? __('this', 'ms-eventman') : __('the main', 'ms-eventman'))
            . __(' site will overwrite site-specific data.', 'ms-eventman')
            . '</div>';
    }

}