<?php

namespace Eventman;
require_once( __DIR__ . '/vendor/autoload.php' );
use Eventman\Includes\MsEventman;
use Eventman\Includes\MsEventmanActivator;
use Eventman\Includes\MsEventmanDeactivator;
use threewp_broadcast\api\api;

/**
 * Plugin Name: Multi-site Event Content Manager
 * Author:			Beau Fiechter (For RTM Business)
 * Author Email:	beau.fiechter@rtmmedia.nl
 * Description:	    Event content manager for multi-site setups.
 * Version:		    1.1.4.2
 */


// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 */
define( 'MS-EVENTMAN', '1.0.3' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-ms-eventman-activator.php
 */
function activateMsEventman() {
    MsEventmanActivator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-ms-eventman-deactivator.php
 */
function deactivateMsEventman() {
	MsEventmanDeactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_ms_eventman' );
register_deactivation_hook( __FILE__, 'deactivate_ms_eventman' );

if ( ! function_exists('dd') ) {

    function dd() {
        call_user_func_array( 'dump' , func_get_args() );
        die();
    }

}


function interevent_get_attachment_url($id, $size) {
    global $interevent_image_id, $interevent_bypass_upload_dir;
    $interevent_bypass_upload_dir = true;
    $interevent_image_id = $id;

    if (is_file(get_attached_file($id))) {
        $image_url = wp_get_attachment_image_url($id, $size);
    } else {
        $interevent_bypass_upload_dir = false;
        if (is_file(get_attached_file($id))) {
            $image_url = wp_get_attachment_image_url($id, $size);
        } else {
            switch_to_blog(get_main_site_id());
            $image_url = wp_get_attachment_image_url($id, $size);
            restore_current_blog();
        }
    }
    return str_replace(get_home_url(get_main_site_id()), get_home_url(get_current_blog_id()), $image_url);
}
add_filter('interevent_get_attachment_url', 'Eventman\\interevent_get_attachment_url', 10, 2);

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function runMsEventman() {

	$plugin = new MsEventman();
	$plugin->run();

}
runMsEventman();
