<?php

namespace Eventman\Includes\Post;

use ReflectionClass;

class Exhibitor extends CustomPostType
{

    public function __construct()
    {
        parent::__construct("exhibitors", [
            'menu_position' => 4
        ]);
        $this->menuIcon = 'dashicons-visibility';
        $this->addField('specialism',             ['type' => 'text',      'label' => __('Specialism')]);
        $this->addField('theme',             ['type' => 'text',      'label' => __('Theme')]);
        $this->addField('name',             ['type' => 'text',      'label' => __('Name', 'ms-eventman')]);
        $this->addField('exhibitor_type',   ['type' => 'text',      'label' => __('Exhibitor Type', 'ms-eventman')]);
        $this->addField('city',             ['type' => 'text',      'label' => __('City', 'ms-eventman')]);
        $this->addField('address',          ['type' => 'text',      'label' => __('Address', 'ms-eventman')]);
        $this->addField('country',          ['type' => 'text',      'label' => __('Country', 'ms-eventman')]);
        $this->addField('email',            ['type' => 'text',      'label' => __('Email', 'ms-eventman')]);
        $this->addField('website',          ['type' => 'text',      'label' => __('Website', 'ms-eventman')]);
        $this->addField('phone_number',     ['type' => 'text',      'label' => __('Phone Number', 'ms-eventman')]);
        $this->addField('description',      ['type' => 'textarea',  'label' => __('Description', 'ms-eventman')]);
        $this->addField('social_facebook',  ['type' => 'text',      'label' => __('Facebook Username', 'ms-eventman')]);
        $this->addField('social_instagram', ['type' => 'text',      'label' => __('Instagram Username', 'ms-eventman')]);
        $this->addField('social_pinterest', ['type' => 'text',      'label' => __('Pinterest Username', 'ms-eventman')]);
        $this->addField('social_linkedin',  ['type' => 'text',      'label' => __('LinkedIn Username', 'ms-eventman')]);
        $this->addField('social_twitter',   ['type' => 'text',      'label' => __('Twitter Username', 'ms-eventman')]);
    }

}