<?php


namespace Eventman\Admin;


trait RequestMetaTrait
{

    protected function isPost(): bool
    {
        return $_SERVER['REQUEST_METHOD'] === 'POST';
    }

    /**
     * @param string $field
     * @return array|mixed
     */
    protected function getPost($field = null)
    {
        return !empty($field) ? $_POST[$field] ?? [] : $_POST;
    }

    protected function isGet(): bool
    {
        return $_SERVER['REQUEST_METHOD'] === 'GET';
    }

    protected function isHead(): bool
    {
        return $_SERVER['REQUEST_METHOD'] === 'HEAD';
    }

    protected function isPut(): bool
    {
        return $_SERVER['REQUEST_METHOD'] === 'PUT';
    }


}