function eventEdit($) {
	$("#dates-amount").on("change", function (e) {
		if (this.value < 1) {
			this.value = 1;
		}
		let value = this.value;
		let dateBoxes = $("[id^=date-]");
		let existingAmount = dateBoxes.length / 2;
		if (existingAmount > parseInt(value)) {
			// remove
			dateBoxes.get().reverse().forEach(function (el) {
				let num = el.id.split("-")[2];
				if (num > parseInt($("#dates-amount").get(0).value) - 1) {
					if (dateBoxes.length > 1) {
						$(el).parent().remove();
					}
				}
			});
		} else if (existingAmount < parseInt(value)) {
			// add
			let diff = parseInt(value) - existingAmount;
			for (let i = 0; i < diff; i++) {
				$("#dates-box").append("<div class=\"dates-box-wrapper\"><input type=\"text\" name=\"term_meta[date_from][]\" class=\"datetime-box\" id=\"date-from-" + (existingAmount + i) + "\" value=\"0\"/> until <input type=\"text\" name=\"term_meta[date_till][]\" id=\"date-till-" + (existingAmount + i) + "\" class=\"datetime-box\" value=\"0\" /></div>");
			}
			$("[id^=date-]").each(function () {
				$(this).datetimepicker("destroy");
				$(this).datetimepicker();
			});
		}
	});
	$("#prices-amount").on("change", function (e) {
		if (this.value < 1) {
			this.value = 1;
		}
		let value = this.value;
		let priceBoxes = $("[id^=price-]");
		let existingAmount = priceBoxes.length / 2;
		if (existingAmount > parseInt(value)) {
			// remove
			priceBoxes.get().reverse().forEach(function (el) {
				let num = el.id.split("-")[2];
				if (num > parseInt($("#prices-amount").get(0).value) - 1) {
					if (priceBoxes.length > 1) {
						$(el).parent().remove();
					}
				}
			});
		} else if (existingAmount < parseInt(value)) {
			// add
			let diff = parseInt(value) - existingAmount;
			for (let i = 0; i < diff; i++) {
				$("#prices-box").append("<div class=\"prices-box-wrapper\"><input type=\"text\" name=\"term_meta[price_type][]\" class=\"price-input-box\" id=\"price-type-" + (existingAmount + i) + "\"/> <input type=\"text\" name=\"term_meta[price_price][]\" class=\"price-input-box\" id=\"price-price-" + (existingAmount + i) + "\" /></div>");
			}
			$(document).scrollTop($("#prices-box").children().last().offset().top);
		}
	});
	$("[id^=date-]").each(function () {
		$(this).datetimepicker();
	});
}

(function ($) {
	$(window).load(function() {
		if (window.location.href.includes('/term.php?taxonomy=events')) {
			eventEdit($);
		}

		$('[id^="publish-check"]').on('change', function(i) {
			if ($(this).data('checked') === false) {
				return;
			}
			let id = this.id;
			let postId = id.split('-')[2];
			if ($(this).attr('checked') === undefined) {
				$('#broadcast-action-select-' + postId).removeAttr('disabled');
			} else {
				$('#broadcast-action-select-' + postId).attr('disabled', 'disabled');
			}
		});

		let threewpBroadcast = $("#threewp_broadcast .inside");
		if (threewpBroadcast.length !== 0) {
			let link = threewpBroadcast.children('.link');
			let customFields = threewpBroadcast.children('.custom_fields');
			let taxo = threewpBroadcast.children('.taxonomies');

			link.prop("checked", "checked");
			link.prop("style", "display:none;");

			customFields.prop("checked", "checked");
			customFields.prop("style", "display:none;");

			taxo.removeProp("checked");
			taxo.prop("style", "display:none;");
		}

	});
	// $('[id^="menu-item-settings-"]').find('.field-css-classes').removeClass('hidden-field');

	window.MultiPostThumbnails.removeThumbnail = function(id, post_type, nonce){
		let blogs = [];
		jQuery("[id^='plainview_sdk_broadcast_form2_inputs_checkboxes_']:checked").each(function(i) {
			blogs.push($(this).val());
		});
		jQuery.post(ajaxurl, {
				action:'set-' + post_type + '-' + id + '-thumbnail',
				post_id: jQuery('#post_ID').val(),
				broadcast: {blogs: blogs},
				thumbnail_id: -1,
				_ajax_nonce: nonce,
				cookie: encodeURIComponent(document.cookie)
			}, function(str){
				if ( str == '0' ) {
					alert( setPostThumbnailL10n.error );
				} else {
					MultiPostThumbnails.setThumbnailHTML(str, id, post_type);
				}
			}
		);
	};

	window.MultiPostThumbnails.setAsThumbnail = function(thumb_id, id, post_type, nonce){
		let blogs = [];
		jQuery("[id^='plainview_sdk_broadcast_form2_inputs_checkboxes_']:checked").each(function(i) {
			blogs.push($(this).val());
		});

		var $link = jQuery('a#' + post_type + '-' + id + '-thumbnail-' + thumb_id);
		$link.data('thumbnail_id', thumb_id);
		$link.text( setPostThumbnailL10n.saving );
		jQuery.post(ajaxurl, {
			action:'set-' + post_type + '-' + id + '-thumbnail',
			post_id: post_id,
			thumbnail_id: thumb_id,
			broadcast: {blogs: blogs},
			_ajax_nonce: nonce,
			cookie: encodeURIComponent(document.cookie)
			}, function(str){
				var win = window.dialogArguments || opener || parent || top;
				$link.text( setPostThumbnailL10n.setThumbnail );
				if ( str == '0' ) {
					alert( setPostThumbnailL10n.error );
				} else {
					$link.show();
					$link.text( setPostThumbnailL10n.done );
					$link.fadeOut( 2000, function() {
						jQuery('tr.' + post_type + '-' + id + '-thumbnail').hide();
					});
					win.MultiPostThumbnails.setThumbnailID(thumb_id, id, post_type);
					win.MultiPostThumbnails.setThumbnailHTML(str, id, post_type);
				}
			}
		);
	};
})(jQuery);
